<div>
    <div class="form-group row">
        <div class="col-md-3">
            <label for="startDate">Start Date</label>
            <input type="date" class="form-control" id="startDate" wire:model="startDate" style="border-radius: 1rem">
        </div>
        <div class="col-md-3">
            <label for="endDate">End Date</label>
            <input type="date" class="form-control" id="endDate" wire:model="endDate" style="border-radius: 1rem">
        </div>
        <div class="col-md-2 mt-4">
            <button type="button" id="filterBtn" wire:click="toFilterActivities" wire:loading.attr="disabled"
                :class="{
                    'custom-button1 mb-2': !$wire.startDate || !$wire.endDate,
                    'btn btn-primary': $wire.startDate && $wire.endDate,
                    'btn btn-primary disabled': !$wire.startDate || !$wire.endDate
                }"
                :disabled="!$wire.startDate || !$wire.endDate">

                <span wire:loading.remove>Filter</span>
                <span wire:loading>
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                        aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                </span>
            </button>



        </div>

    </div>
    <div id="my-table-logs" class="mt-2">
        <table id="example" class="my-table" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center" style="border-top-left-radius: 1rem">Activity</th>
                    <th class="text-center">Description</th>
                    <th class="text-center">Caused By</th>
                    <th class="text-center">Before</th>
                    <th class="text-center">After</th>
                    <th class="text-center" style="border-top-right-radius: 1rem">Date</th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-center"><?php echo e(ucfirst($activity->event)); ?> <?php echo e($activity->log_name); ?></td>
                        <td><?php echo e($activity->description); ?></td>
                        <td class="text-center"><?php echo e($activity->causer->name); ?></td>
                        <!--[if BLOCK]><![endif]--><?php if($activity->event === 'updated'): ?>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if(is_array($activity->changes['old'])): ?>
                                    <!--[if BLOCK]><![endif]--><?php if(isset($activity->changes['old']['qty'])): ?>
                                        Quantity : <?php echo e($activity->changes['old']['qty']); ?> <br>
                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                                    <!--[if BLOCK]><![endif]--><?php if(isset($activity->changes['old']['total_price'])): ?>
                                        Total Price : <?php echo e($activity->changes['old']['total_price']); ?> <br>
                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if(is_array($activity->changes['attributes'])): ?>
                                    <!--[if BLOCK]><![endif]--><?php if(isset($activity->changes['attributes']['qty'])): ?>
                                        Quantity : <?php echo e($activity->changes['attributes']['qty']); ?> <br>
                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                                    <!--[if BLOCK]><![endif]--><?php if(isset($activity->changes['attributes']['total_price'])): ?>
                                        Total Price : <?php echo e($activity->changes['attributes']['total_price']); ?> <br>
                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </td>
                        <?php else: ?>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if(is_array($activity->changes['old'])): ?>
                                    <?php
                                        $newKeys = [
                                            'code' => 'Code',
                                            'name' => 'Name',
                                            'price' => 'Price',
                                            'qty' => 'Quantity',
                                            'id_member' => 'Member',
                                            'total_price' => 'Total Price',
                                            'created_at' => 'Scanned',
                                        ];
                                    ?>

                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $activity->changes['old']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $itemChange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!--[if BLOCK]><![endif]--><?php if($key === 'created_at'): ?>
                                            <?php echo e($newKeys[$key]); ?> :
                                            <?php echo e(\Carbon\Carbon::parse($itemChange)->format('l, d F Y, H:i:s')); ?> <br>
                                        <?php elseif(isset($newKeys[$key])): ?>
                                            <?php echo e($newKeys[$key]); ?> : <?php echo e($itemChange); ?> <br>
                                        <?php else: ?>
                                            <?php echo e($key); ?> : <?php echo e($itemChange); ?> <br>
                                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td class="text-center">
                                Deleted
                            </td>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->

                        <td><?php echo e($activity->formatted_created_at); ?></td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
</div>
<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

<script>
    function handleLoadingState() {
        const buttonText = document.getElementById('buttonText');
        const loadingContent = document.getElementById('loadingContent');

        buttonText.style.display = 'none'; // Hide the "Filter" text
        loadingContent.style.display = 'inline'; // Show the loading spinner and text
    }

    Livewire.on('activityFiltered', () => {
        const buttonText = document.getElementById('buttonText');
        const loadingContent = document.getElementById('loadingContent');

        buttonText.style.display = 'inline'; // Show the "Filter" text
        loadingContent.style.display = 'none'; // Hide the loading spinner and text
    });

    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
</script>
<?php /**PATH C:\laragon\www\rybc\resources\views/livewire/activity/activity-log-table.blade.php ENDPATH**/ ?>