<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/"><?php echo e(__('Main')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/it_out"><?php echo e(__('Inv Transfer Out')); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php echo e(__('Detail')); ?>

                    </li>
                </ol>

                <button wire:click="close" type="button" class="button-custom-secondary btn-sm ml-2"><?php echo e(__('Close')); ?></button>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card p-2 mb-3 ">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary"><?php echo e(__('IT Out Detail no. ')); ?> <span class=""><?php echo e($no->no); ?></span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary"><?php echo e(__('Date : ')); ?> <span class=""><?php echo e($no->date); ?></span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary"><?php echo e(__('Remark : ')); ?> <span class=""><?php echo e($no->comments); ?></span></h6>
                        </div>
                    </div>

                    <div class="table-responsive table-it-in-detail">
                        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                    <th scope="col"><?php echo e(__('Code')); ?></th>
                                    <th scope="col"><?php echo e(__('Barcode')); ?></th>
                                    <th scope="col"><?php echo e(__('Name')); ?></th>
                                    <th scope="col" style="border-top-right-radius: 1rem"><?php echo e(__('Qty')); ?></th>
                                </tr>
                            </thead>

                            <tbody class="small">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="col"><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($detail->code); ?></td>
                                    <td><?php echo e($detail->barcode); ?></td>
                                    <td><?php echo e($detail->name); ?></td>
                                    <td><?php echo e(number_format($detail->qty)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div wire:ignore.self>
                    <table id="table" class="table dataTables_wrapper dt-bootstrap5 text-white" style="width:100%; ">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col" colspan="4"></th>
                                <th scope="col" style="text-align: right;"><?php echo e(__('Total Qty')); ?></th>
                            </tr>
                        </thead>

                        <tbody class="small">
                            
                            <tr>
                                <td colspan="2">Total</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td colspan="4"></td>
                                <td style="text-align: right;"><?php echo e(number_format($details->sum('qty'), 0, ',', ',')); ?></td>
                            </tr>
                           
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div><?php /**PATH C:\laragon\www\rybc\resources\views/livewire/pos/it/itout/it-out-detail.blade.php ENDPATH**/ ?>