<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/"><?php echo e(__('Main')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/it_reqout"><?php echo e(__('Inv Transfer Request Out')); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php echo e(__('Detail')); ?>

                    </li>
                </ol>

                <div>
                        <button wire:click="close" type="button"
                    class="button-custom-secondary btn-sm ml-2"><?php echo e(__('Close')); ?></button>
                </div>
                
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card" style="margin-top: -1rem; margin-bottom: 1rem;">
                        <div class="m-2">
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary"><?php echo e(__('IT Request Out Detail No. ')); ?> <span
                                        class=""><?php echo e($no->no); ?></span></h6>
                            </div>
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary"><?php echo e(__('Date : ')); ?> <span
                                        class=""><?php echo e($no->date); ?></span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-1">
                                <h6 class="card-title text-secondary"><?php echo e(__('Remark : ')); ?> <span
                                        class=""><?php echo e($no->comments); ?></span></h6>
                            </div>
                            
                        </div>
                       
                    </div>

                        <div class="table-responsive">
                            <table id="table" class="my-table dataTables_wrapper dt-bootstrap5"
                                style="width:100%;">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                        <th scope="col"><?php echo e(__('Code')); ?></th>
                                        <th scope="col"><?php echo e(__('Barcode')); ?></th>
                                        <th scope="col"><?php echo e(__('Name')); ?></th>
                                        <th scope="col"><?php echo e(__('Qty')); ?></th>
                                        <th scope="col" style="border-top-right-radius: .5rem"><?php echo e(__('Qty Send')); ?></th>


                                    </tr>
                                </thead>

                                <tbody class="small">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr wire:key="<?php echo e($detail->code); ?>">
                                            <th scope="col"><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($detail->code); ?></td>
                                            <td><?php echo e($detail->barcode); ?></td>
                                            <td><?php echo e($detail->name); ?></td>
                                            <td><?php echo e(number_format($detail->qty)); ?></td>

                                            <td>

                                                    <?php echo e($detail->qty_send); ?>


                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>

                        <div wire:ignore.self>
                            <table id="table" class="table dataTables_wrapper dt-bootstrap5"
                                style="width:100%; ">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col" colspan="4"></th>
                                        <th scope="col" style="text-align: right;"><?php echo e(__('Total Qty')); ?></th>
                                    </tr>
                                </thead>

                                <tbody class="small">

                                    <tr>
                                        <td colspan="2">Total</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td colspan="4"></td>
                                        <td style="text-align: right;">
                                            <?php echo e(number_format($details->sum('qty'), 0, ',', ',')); ?></td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        
                </div>
            </div>
        </div>
    </div>


    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pos.it.itreqin.add-item-req', ['no' => $no]);

$__html = app('livewire')->mount($__name, $__params, 'Ci17cjv', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>


</div>
<?php /**PATH C:\laragon\www\rybc\resources\views/livewire/pos/it/it-req-out/it-req-out-detail.blade.php ENDPATH**/ ?>