<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-192x192.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-512x512.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/apple-touch-icon.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-16x16.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-32x32.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon.ico')); ?>" type="image/x-icon">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">

    <title><?php echo e(config('app.name')); ?> - Bestari Jaya</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

</head>

<style>
    .login-here{
        background-color: #4a4cd6; 
        color: #fff; 
        text-decoration: underline; 
        text-transform: lowercase; 
        border-radius: .5rem; 
        padding-inline: 10px; 
        font-size: 15px; 
        margin-top: -6px
    }

    .login-here:hover{
        background-color: #098cdf;
    }
    .logo-home img {
        max-width: 160px;
        height: auto;
    }
    .home-text {
        font-size: 1rem;
        font-weight: 600;
        margin-top: 10px;
    }
    .arrow {
        color: white;
    }
    .animate-hover:hover {
        transform: scale(1.05);
        transition: transform 0.3s;
    }

    *,
    *:before,
    *:after{
    box-sizing: border-box;
    }

    .wrapper{
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    }

    a{
    display: block;
    text-decoration: none;
    text-align: center;
    border-radius: 50px;
    color: seagreen;
    font-size: 20px;
    font-family: arial;
    position: relative;
    overflow: hidden;
    background: transparent;
    text-transform: uppercase;
    transition: all .35s;
    }

    a:before,
    a:after{
    position: absolute;
    content: "";
    width: 100%;
    height: 100%;
    top: -100%;
    left: 0;
    background: #13202b13;
    z-index: -1;
    transition: all .35s;
    }

    a:before{
    opacity: .5;
    }

    a:after{
    transition-delay: .2s;
    }

    a:hover{
    color: #fff;
    }

    a:hover:before,
    a:hover:after{
    top: 0;
    }

    .typing {
        overflow: hidden; /* Ensures the text is clipped at the start of the animation */
        border-right: .15em solid orange; /* The typewriter cursor */
        white-space: nowrap; /* Keeps the content on a single line */
        margin: 0 auto; /* Centers the text */
        letter-spacing: .15em; /* Adjust as needed */
        animation: 
            typing 2s steps(40, end), /* Increased steps for smoother animation */
            blink-caret .7s step-end infinite; /* Blinking cursor effect */
    }

    /* The typing effect */
    @keyframes typing {
        from { width: 0 }
        to { width: 100% } /* Changed to 100% to type out the full text */
    }

    /* The typewriter cursor effect */
    @keyframes blink-caret {
        from, to { border-color: transparent }
        50% { border-color: orange; }
    }

    .arrow-icon {
        animation: bounce 2s infinite;
    }

    @keyframes bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-10px);
        }
        60% {
            transform: translateY(-5px);
        }
    }

</style>
<body class="">
    <div class="bg-center bg-home">
        <div class="bg-center bg-home">
            <?php if(Route::has('login')): ?>
            
            <?php endif; ?>
            <div style="display: flex; flex-direction: column; justify-content: center; align-items: center; height: 100vh;text-align: center;">
                <div class="logo-home my-4">
                    <img src="<?php echo e(asset('assets/Logo Softcomp - RGB-01.png')); ?>" alt="Deskripsi Gambar">
                </div>
                <div>
                    <?php if(auth()->guard()->check()): ?>
                        <h1 class="mt-5 mb-3 home-text1 typing">Welcome, <?php echo e(auth()->user()->name); ?> 👋</h1>
                    <?php else: ?>
                        <div class="mt-5 mb-3 d-flex gap-2" style="justify-content: center; align-items: center">
                            <h1 class="home-text1">Please log in </h1>
                            <a href="<?php echo e(route('login')); ?>" class="login-here">here</a>
                            
                        </div>                        
                    <?php endif; ?>
                </div>
                <div class="mt-4 container">
                    <div class="row d-flex justify-content-center">
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('welcome.dashboard')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z"/>
                                        </svg>
                                    </div>
                                    <h2 class="home-text">POS</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('member.index')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                                        </svg> 
                                    </div>
                                    <h2 class="home-text">Member</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('item')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Item</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('opname')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
                                        </svg> 
                                    </div>
                                    <h2 class="home-text">Opname</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('activity-log')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Activity Log</h2>
                                </div>
                            </a>
                        </div>
                    </div>
                    
                    <div class="row d-flex justify-content-center">
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('salesemp')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Sales Emp</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('it.itin')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M7.5 21 3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">IT</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('welcome.returnsale')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Return</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('synchronization')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 12c0-1.232-.046-2.453-.138-3.662a4.006 4.006 0 0 0-3.7-3.7 48.678 48.678 0 0 0-7.324 0 4.006 4.006 0 0 0-3.7 3.7c-.017.22-.032.441-.046.662M19.5 12l3-3m-3 3-3-3m-12 3c0 1.232.046 2.453.138 3.662a4.006 4.006 0 0 0 3.7 3.7 48.656 48.656 0 0 0 7.324 0 4.006 4.006 0 0 0 3.7-3.7c.017-.22.032-.441.046-.662M4.5 12l3 3m-3-3-3 3" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Sync</h2>
                                </div>
                            </a>
                        </div>
                        <div class="col col-md-2 mb-4">
                            <a href="<?php echo e(route('settings')); ?>" style="border-radius: 1rem" class="d-flex align-items-center justify-content-between p-3 bg-light custom-bg text-decoration-none text-white animate-hover shadow-lg">
                                <div class="d-flex text-start gap-2" style="flex-direction: column">
                                    <div class="custom-bg-item bg-card-welcome me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-7 h-7" id="icon-color-home">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                        </svg>
                                    </div>
                                    <h2 class="home-text">Setting</h2>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="content-end" style="text-align: right;">
                        <h5>
                            <?php echo e(env('VERSION')); ?>

                        </h5>
                    </div>
                </div>
                
            </div>
            
        </div>
    </div>
    </div>
</body>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const currentTheme = localStorage.getItem('theme') || 'light'; // Get the stored theme or default to 'light'
        document.documentElement.setAttribute('data-bs-theme', currentTheme);

        // Set the icon based on the theme
        const themeIcon = document.getElementById('themeIcon');
        if (currentTheme === 'dark') {
            themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
        } else {
            themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
        }
    });

    const toggleThemeButton = document.getElementById('toggleThemeButton');
    toggleThemeButton.addEventListener('click', () => {
        const currentTheme = document.documentElement.getAttribute('data-bs-theme');
        let newTheme = 'light';

        if (currentTheme === 'light') {
            newTheme = 'dark';
            themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
        } else {
            newTheme = 'light';
            themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
        }

        document.documentElement.setAttribute('data-bs-theme', newTheme);
        localStorage.setItem('theme', newTheme); // Store the theme in local storage
    });
</script>

</html><?php /**PATH C:\laragon\www\rybc\resources\views/welcome/welcome.blade.php ENDPATH**/ ?>