<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <style>
        * {
            font-family: 'Courier New', Courier, monospace;
            font-size: 13px;
        }

        td,
        th,
        tr,
        table {
            border-collapse: collapse;
            padding: 3px;
            font-size: 1em;
        }

        td.qty,
        th.qty {
            width: 30px;
            max-width: 30px;
        }

        td.keterangan,
        th.keterangan {
            width: 100px;
            max-width: 100px;
            word-break: break-all;
        }

        td.harga,
        th.harga {
            width: 80px;
            max-width: 80px;
            word-break: break-all;
        }

        td.jumlah,
        th.jumlah {
            width: 90px;
            max-width: 90px;
            word-break: break-all;
        }

        .centered {
            text-align: center;
            align-content: center;
        }

        .align-right {
            text-align: right;
        }

        .container {
            width: 76.2mm;
            max-width: 76.2mm;
        }

        .font {
            font-size: 1.2em;
            font-weight: bold;
        }

        .font-isi {
            font-size: 1em;
            font-weight: bold;
        }

        .flex {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            margin-right: 4%;
            margin-left: 2%;
            margin-top: 3%;
        }

        .size {
            font-size: 1.2em;
        }

        @media print {

            @page {
                size: 3in auto;
                /* Set the page width to 3 inches and height to auto */
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                box-shadow: none;
            }
        }
    </style>
    <title> <?php echo e(env('APP_NAME')); ?> || <?php echo e($invoice->no); ?></title>
</head>

<body>
    <div class="container">
        
        <p class="centered" style="font-size: 1em;"><?php echo e($setting->wh_name); ?><br>Telp: <?php echo e($setting->phone); ?> <br><?php echo e($setting->address); ?></p>
        
        
        <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>

        <div class="flex">
            <?php
                $cashierName = $invoice->users_name;
                $atPosition = strpos($cashierName, '@');
                if ($atPosition !== false) {
                    $cashierName = substr($cashierName, 0, $atPosition);
                }
            ?>
            <div>Cashier : <?php echo e($cashierName); ?>


            </div>
        </div>
        <div class="flex" style="margin-top: 2px;">
            <div>Bill No : <?php echo e($invoice->no); ?></div>
        </div>
        <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
            <div>Date&nbsp; &nbsp; : <?php echo e(\Carbon\Carbon::parse($invoice->created_at)->format('d/m/Y H:i:s')); ?></div>
        </div>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <table style="margin-top:10px; width:100%;">
            <thead>
                <tr style="border-bottom: 1px dashed rgb(0, 0, 0);">
                    <td class="keterangan" style="text-align: left;">Item</td>
                    <td class="qty centered">Qty</td>
                    <td class="harga centered">Price</td>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="font-size: 0.75em;">
                        <td class="keteranga size"><?php echo e($dt->name); ?></td>
                        <td class="qty centered size">

                            <?php echo e(intval($dt->qty)); ?>


                        </td>
                        <td class="harga centered size">
                            <?php echo e(number_format($dt->nprice, 0, ',', '.')); ?>

                            <?php if($dt->price != $dt->nprice): ?>
                                <br>(<?php echo e(number_format($dt->nprice - $dt->price, 0, ',', '.')); ?>)
                            <?php endif; ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
        <?php if($invoice->payment == 'Multi' || $invoice->payment == 'Card'): ?>
            <?php
                $note = json_decode($invoice->note, true);
            ?>
            <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>
            <div class="flex" style="margin-top: 10px;">
                <div>Card Number : <?php echo e($note['nomor_kartu']); ?></div>
            </div>
            <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
                <div>Name&nbsp; &nbsp; &nbsp; &nbsp; : <?php echo e($note['nama_pemegang_kartu']); ?></div>
            </div>
            <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>
        <?php endif; ?>
        <div>
            <div style="margin-left: 90px;" class="flex">
                <div>Sub Total &nbsp;: </div>
                <div><?php echo e(number_format($invoice->subtotal, 0, ',', '.')); ?></div>
            </div>
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>Discount &nbsp;&nbsp;:</div>
                <div><?php echo e(number_format($invoice->disc_total, 0, ',', '.')); ?></div>
            </div>
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>GrandTotal :</div>
                <div><?php echo e(number_format($invoice->must_paid, 0, ',', '.')); ?></div>
            </div>
            <?php if($invoice->payment == 'Multi' || $invoice->payment == 'Card'): ?>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Card &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div><?php echo e(number_format($note['transfer'], 0, ',', '.')); ?></div>
                </div>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Cash &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div><?php echo e(number_format($note['cash'] ?? 0, 0, ',', '.')); ?></div>
                </div>
            <?php else: ?>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Card &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div>0</div>
                </div>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Cash &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div><?php echo e(number_format($invoice->paid, 0, ',', '.')); ?></div>
                </div>
            <?php endif; ?>
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>Change &nbsp;&nbsp;&nbsp;&nbsp;:</div>
                <div><?php echo e(number_format($invoice->change, 0, ',', '.')); ?></div>
            </div>
        </div>
        <br>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <div class="flex" style="margin-top: 10px; margin-bottom:10px;">
            <div>Handled By : <?php echo e($invoice->sales_name); ?></div>
        </div>

        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <p class="centered" style="font-size: 1.1em;">
            <?php echo $footer; ?>

        </p>
        <br><br>
        <p style="text-align:center;">( _ _ _ _ _ _ _ _ _ _ _ )</p>
        &nbsp;
        <br>
    </div>
    <script type="text/javascript">
        window.onload = function() {
            window.print();
        };

        var beforePrint = function() {
            console.log('Functionality to run before printing.');
        };

        var afterPrint = function() {
            setTimeout(function() {
                window.close();
            }, 6000); 
        };

        // Listen for print events
        if (window.matchMedia) {
            var mediaQueryList = window.matchMedia('print');
            mediaQueryList.addListener(function(mql) {
                if (mql.matches) {
                    beforePrint();
                } else {
                    afterPrint();
                }
            });
        }

        window.onbeforeprint = beforePrint;
        window.onafterprint = afterPrint;
    </script>

</body>

</html>
<?php /**PATH C:\laragon\www\Posprorycroft\resources\views/report/print.blade.php ENDPATH**/ ?>