<div wire:ignore.self class="modal fade" id="modalSyncAll" data-bs-backdrop="static" tabindex="-1" aria-labelledby="modalSyncAllLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSyncAllLabel">Sync Inventory Transfer In</h5>
                <div id="loadingSpinner" class="spinner-border text-primary" role="status" style="display: none;">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <!--[if BLOCK]><![endif]--><?php if($isloading): ?>
                <div id="loadingSpinner" class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="modal-body">
                <div class="col-auto">
                    <div class="form-check">
                        <input type="checkbox" id="selectAll" class="form-check-input" wire:model.live="isCheckedAll" checked>
                        <label class="form-check-label" for="selectAll">Sync All</label>
                    </div>
                </div>
            </div>
            <div class="mx-2 row align-items-center">
                <div class="col">
                    <label for="filterBy">Filter By</label>
                    <select id="filterBy" class="form-select" wire:model.live="selectedFilter" <?php if($isCheckedAll): ?> disabled <?php endif; ?>>
                        <option value="Period">Period</option>
                        <option value="Docnum">Document Number</option>
                    </select>
                </div>
            </div>
            <!--[if BLOCK]><![endif]--><?php if(!$isDocnum): ?>
            <div class="mt-2 mx-2 row align-items-center">
                <div class="col">
                    <label for="startDate">Start Date</label>
                    <input type="date" class="form-control" id="startDate" wire:model.live="startDate"  <?php if($isCheckedAll): ?> disabled <?php endif; ?>>
                </div>
                <div class="col">
                    <label for="endDate">End Date</label>
                    <input type="date" class="form-control" id="endDate" wire:model.live="endDate" <?php if($isCheckedAll): ?> disabled <?php endif; ?>>
                </div>
            </div>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            <!--[if BLOCK]><![endif]--><?php if($isDocnum): ?>
            <div class="mt-2 mx-2 row align-items-center">
                <div class="col">
                    <label>IT Docnum</label>
                    <input type="text" class="form-control" wire:model.live="docNum" <?php if($isCheckedAll): ?> disabled <?php endif; ?> oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                </div>
            </div>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            <div wire:ignore.self class="modal-footer mt-4">
                <button type="button" id="closeSyncAll" class="button-custom-danger" data-bs-dismiss="modal" <?php if($isloading): ?> disabled="true" <?php endif; ?>>Close</button>
            <!--[if BLOCK]><![endif]--><?php if($isCheckedAll): ?>
                <button id="buttonSync" type="button" class="custom-button1"
                        wire:click="firstClick" 
                        <?php if($isloading): ?> disabled="true" <?php endif; ?>
                        onclick="disableButton(this)"
                >          
                <!--[if BLOCK]><![endif]--><?php if(!$isloading): ?>
                    <span id="innerSpan">Sync all</span>
                <?php else: ?>
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->      
                </button>
            <?php else: ?>
                <button id="buttonSync" type="button" class="custom-button1"
                        wire:click="firstClick"
                        <?php if($isloading): ?> disabled="true" <?php endif; ?>
                        <?php if($isDocnum && empty($docNum)): ?> disabled="true" <?php endif; ?> onclick="disableButton(this)"
                >
                <!--[if BLOCK]><![endif]--><?php if($isDocnum): ?>
                    <!--[if BLOCK]><![endif]--><?php if(!$isloading): ?>
                        <span id="innerSpan">Sync by Docnum</span>
                    <?php else: ?>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    <!--[if BLOCK]><![endif]--><?php if(!$isloading): ?>
                        <span id="innerSpan">Sync by Period</span>
                    <?php else: ?>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </button>
            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>
</div>
<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


<script>
    function disableButton(button) {
        button.disabled = true;
        var closeButton = document.getElementById('closeSyncAll');
        
        if (closeButton !== null) {
            closeButton.disabled = true;
        }

    }
</script>
<?php /**PATH C:\laragon\www\Posprorycroft\resources\views/livewire/pos/it/itin/syncit.blade.php ENDPATH**/ ?>