<div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalCheapest" tabindex="-1"
    aria-labelledby="modalCheapestLabel" aria-hidden="true" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Cheapest Item</h5>
            </div>
            <div class="modal-body">
                <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                    <div class="form-group">
                        <label class="small text-muted mb-1">Kode Produk</label>
                        <div class="d-flex">
                            <input type="text" class="form-control" wire:model.live="searchcheapest"
                                placeholder="Type to search..."
                                id="searchInputModal" autofocus autocomplete="off"
                                @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, <?php echo e(sizeof($products) - 1); ?>)"
                                @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }">
                        </div>

                        <?php if($selectedProduct === null && sizeof($products) > 0): ?>
                            <div class="dropdown-menu d-block py-0" style="width: 770px">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndex === <?php echo e($index); ?> }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button"
                                                wire:click="selectProductByClick('<?php echo e($product->code); ?>')"
                                                class="btn btn-link"
                                                :class="{ 'text-white': selectedIndex === <?php echo e($index); ?> }">
                                                <?php echo e($product->code); ?> || <?php echo e($product->name); ?>

                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>

                <table class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th class="text-center">#</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($cart['id']); ?></td>
                                <td><?php echo e($cart['itemcode']); ?></td>
                                <td><?php echo e($cart['itemname']); ?></td>
                               
                                <td>
                                    <?php echo e('Rp ' . number_format($cart['itemprice'], 0, ',', '.')); ?>

                                </td>
                                <td width="80px">
                                    <input class="form-control form-control-sm quantity-input" type="number"
                                        id="quantity-<?php echo e($index); ?>"
                                        wire:model="carts.<?php echo e($index); ?>.itemqty"
                                        wire:change="updateItemQty('<?php echo e($index); ?>', $event.target.value)"
                                        >
                                </td>
                                <td class="text-center">
                                    <button wire:click="deleteFromCarts(<?php echo e($index); ?>)"
                                        class="badge button-custom-danger" type="button">
                                        Delete
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
                <div class="modal-footer">
                    <button type="button" id="saveButton" class="custom-button1"
                        wire:click="save" wire:keydown.enter="save"
                        <?php if(!$carts): ?> disabled <?php endif; ?> <?php if($isLimit): ?> data-bs-dismiss="modal" <?php endif; ?>>Save</button>
                </div>
            </div>
        </div>
    </div>
<?php /**PATH C:\laragon\www\Posprorycroft\resources\views/livewire/cashier/add-cheapest-item.blade.php ENDPATH**/ ?>