<?php

use App\Livewire\Pos\Item\ItemIndex;
use App\Livewire\Pos\Opname\OpnameInput;
use App\Livewire\Pos\Opname\OpnameResult;
use App\Http\Controllers\Auth\FacebookSocialiteController;
use App\Http\Controllers\Auth\GoogleSocialiteController;
use App\Http\Controllers\Auth\TwitterSocialiteController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MemberController;
use App\Livewire\Cashier\Display;
use App\Livewire\Pos\It\ItIn\ItInIndex;
use App\Livewire\Pos\It\ItOut\ItOutDetail;
use App\Livewire\Pos\It\ItOut\ItOutIndex;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
	return view('welcome.welcome');
});

Route::get('/clear-cache', function() {
    $responseConfigClear = Artisan::call('config:clear');
    $outputConfigClear = Artisan::output();

    $responseCacheClear = Artisan::call('cache:clear');
    $outputCacheClear = Artisan::output();

    $responseConfigCache = Artisan::call('config:cache');
    $outputConfigCache = Artisan::output();

    $responseOptimizeClear = Artisan::call('optimize:clear');
    $outputOptimizeClear = Artisan::output();

    $output = [
        'config_clear' => [
            'exit_code' => $responseConfigClear,
            'output' => $outputConfigClear,
        ],
        'cache_clear' => [
            'exit_code' => $responseCacheClear,
            'output' => $outputCacheClear,
        ],
        'config_cache' => [
            'exit_code' => $responseConfigCache,
            'output' => $outputConfigCache,
        ],
        'optimize_clear' => [
            'exit_code' => $responseOptimizeClear,
            'output' => $outputOptimizeClear,
        ],
    ];

    return $output;
});

// Route::get('/rawr', function () {
//     return view('report.reportsandbox');
// });
Route::get('/item', ItemIndex::class);
Route::get('/opname/input', OpnameInput::class);
Route::get('/opname/result', OpnameResult::class);
#transaction
Route::get('/it_in', ItInIndex::class);
Route::get('/it_out', ItOutIndex::class)->name('it_out');
Route::get('/it_out/view/{it}', ItOutDetail::class)->name('it_out_detail');

Auth::routes();
Route::get('auth/twitter', [TwitterSocialiteController::class, 'redirectToTwitter'])->name('auth.twitter');  // redirect to twitter login
Route::get('callback/twitter', [TwitterSocialiteController::class, 'handleCallback']);    // callback route after twitter account chose

Route::get('auth/google', [GoogleSocialiteController::class, 'redirectToGoogle'])->name('auth.google');  // redirect to google login
Route::get('callback/google', [GoogleSocialiteController::class, 'handleCallback']);    // callback route after google account chosen

Route::get('auth/facebook', [FacebookSocialiteController::class, 'redirectToFacebook'])->name('auth.facebook');
Route::get('callback/facebook', [FacebookSocialiteController::class, 'handleCallback']);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/thankyou', [App\Http\Controllers\MemberController::class, 'thanks'])->name('thanks');
Route::post('/logouts', [App\Http\Controllers\Auth\LogoutController::class, 'logout'])->name('logouts');
Route::post('/logins', [App\Http\Controllers\Auth\LoginController::class, 'logins'])->name('logins');
Route::get('/forgot-password', [App\Http\Controllers\DashboardController::class, 'forgotpass'])->name('forgotpassword');



Route::controller(DashboardController::class)->middleware(['auth'])->name('welcome.')->group(function () {
	Route::get('/cashier', 'index')->name('dashboard');
    Route::get('/display', 'display')->name('display');
	Route::get('/returnsale', 'returnsale')->name('returnsale');
	Route::get('/report/invoice', 'reportinvoice')->name('reportinvoice');
	Route::get('/welcome', 'welcome')->name('welcome');
	Route::get('/welcome/register', 'welcomeregister')->name('register');
	Route::post('/welcome/register', 'storeregister')->name('store');
});

Route::get('/item', [App\Http\Controllers\DashboardController::class, 'item'])->middleware(['auth'])->name('item');
Route::get('/it_in', [App\Http\Controllers\DashboardController::class, 'itin'])->middleware(['auth'])->name('it.itin');
Route::get('/it_in/view/{it}', [App\Http\Controllers\DashboardController::class, 'itindetail'])->middleware(['auth'])->name('it.it_in_detail');
Route::get('/it_req', [App\Http\Controllers\DashboardController::class, 'itreq'])->middleware(['auth'])->name('it.itreq');
Route::get('/it_req/view/{it}', [App\Http\Controllers\DashboardController::class, 'itreqdetail'])->middleware(['auth'])->name('it.it_req_detail');
Route::get('/it_out', [App\Http\Controllers\DashboardController::class, 'itout'])->middleware(['auth'])->name('it.itout');
Route::get('/it_out/view/{it}', [App\Http\Controllers\DashboardController::class, 'itoutdetail'])->middleware(['auth'])->name('it.it_out_detail');
Route::get('/it_reqout', [App\Http\Controllers\DashboardController::class, 'itreqout'])->middleware(['auth'])->name('it.itreqout');
Route::get('/it_reqout/create', [App\Http\Controllers\DashboardController::class, 'itreqoutcreate'])->middleware(['auth'])->name('it.itreqoutcreate');
Route::get('/it_reqout/view/{it}', [App\Http\Controllers\DashboardController::class, 'itreqoutdetail'])->middleware(['auth'])->name('it.itreqoutdetail');
Route::get('/it_reqout/print/{it}', [App\Http\Controllers\DashboardController::class, 'itreqoutprint'])->middleware(['auth'])->name('it.itreqoutprint');

Route::get('/opname', [App\Http\Controllers\DashboardController::class, 'opname'])->middleware(['auth'])->name('opname');
Route::get('/opname/result', [App\Http\Controllers\DashboardController::class, 'resultopname'])->middleware(['auth'])->name('opnameresult');
Route::get('/salesemp', [App\Http\Controllers\DashboardController::class, 'salesemp'])->middleware(['auth'])->name('salesemp');
Route::get('/synchronization', [App\Http\Controllers\DashboardController::class, 'synchronization'])->middleware(['auth'])->name('synchronization');

Route::controller(DashboardController::class)->middleware(['auth'])->name('report.')->group(function () {
	Route::get('/report/invoice', 'reportinvoice')->name('reportinvoice');
	Route::get('/report/all', 'reportinvoicereturnsale')->name('reportinvoicereturnsale');
	Route::get('/report/invoice/detail', 'reportinvoicedetail')->name('reportinvoicedetail');
	Route::get('/report/returnsale', 'reportreturnsale')->name('reportreturnsale');
	Route::get('/report/transactiomember', 'reporttransactionmember')->name('reporttransactionmember');
	Route::get('/report/voucher', 'reportvoucher')->name('voucher');
    Route::get('/print/{no}', 'print')->name('print');

});


Route::controller(MemberController::class)->middleware(['auth'])->name('member.')->group(function () {
	Route::get('/member', 'index')->name('index');
	Route::post('/member/register', 'storeoauth')->name('storeoauth');
	Route::get('/member/register', 'createoauth')->name('createoauth');
	Route::get('/member/{id}/edit', 'edit')->name('edit');
	Route::put('/member/{id}/update', 'update')->name('update');
	Route::delete('/member/{id}/delete', 'delete')->name('delete');
	Route::put('/member/{id}/updatestatus', 'updateStatus')->name('updatestatus');
});
Route::post('/member/create', [App\Http\Controllers\MemberController::class, 'store'])->name('member.store');

Route::get('/activity-log', [App\Http\Controllers\ActivityLogController::class, 'index'])->middleware(['auth'])->name('activity-log');
Route::get('/settings', [App\Http\Controllers\DashboardController::class, 'settings'])->middleware(['auth'])->name('settings');
Route::get('/changepassword', [App\Http\Controllers\DashboardController::class, 'changepass'])->middleware(['auth'])->name('changepass');


Auth::routes();
