@extends('layouts.app')

@section('content')
<div class="">
    <div class="row justify-content-center">
        <div class="col"  >
            <div class="">
                <div class="title-page mb-0 fw-bolder mb-lg-5">{{ __('Register New Member') }}</div>

                <div class="">
                    <form method="POST" action="{{ route('member.storeoauth') }}">
                        @csrf
                        @if(auth()->user()->social_type == 'Twitter')
                        <div class="form-group pb-3">
                            <label for="email" class="mb-2">{{ __('Email Address') }}</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        @endif
                       

                        <div class="form-group pb-3">
                            <label for="hp" class="mb-2">{{ __('Handphone') }}</label>

                            <div class="col-md-6">
                                <input id="hp" type="hp" class="form-control @error('hp') is-invalid @enderror" name="phone" value="{{ old('hp') }}" required autocomplete="hp">

                                @error('hp')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group pb-3">
                            <label for="alamat" class="mb-2">{{ __('Address') }}</label>

                            <div class="col-md-6">
                                <input id="alamat" type="address" class="form-control @error('address') is-invalid @enderror" name="address" value="{{ old('address') }}" required autocomplete="address">

                                @error('address')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="">
                                <button type="submit" class="custom-button1">
                                    {{ __('Save') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
