<div class="mt-5">
    <div class="form-group row">
        <div class="col-md-4">
            <label for="startDate">Start Date</label>
            <input type="date" class="form-control" id="startDate" style="border-radius: 1rem" wire:model.live="startDate">
        </div>
        <div class="col-md-4">
            <label for="endDate">End Date</label>
            <input type="date" class="form-control" id="endDate" style="border-radius: 1rem" wire:model.live="endDate">
        </div>
        @if ($startDate != '')
            <div class="col-md-4 mt-4">
                <button type="button" wire:click="filters" class="custom-button1 mb-2">Filter</button>
                <button type="button" wire:click="clearfilters" class="button-custom-danger mb-2">Clear Filter</button>
            </div>
        @else
            <div class="col-md-4 mt-4">
                <button type="button" class="custom-button1 mb-2" disabled>Filter</button>
                <button type="button"class="button-custom-danger mb-2" disabled>Clear Filter</button>
            </div>
        @endif
    </div>
    <div class="col-md-4 mt-2">
        <button type="button" wire:click="exportExcel" class="custom-button1 mb-2">Export Excel</button>
    </div>
    <table class="my-table mt-2" style="width:100%">
        <thead>
            <tr>
                <th style="border-top-left-radius: .5rem">Member ID</th>
                <th>Member Name</th>
                <th>Member HP</th>
                <th>Member Email</th>
                <th>Member Alamat</th>
                <th style="border-top-right-radius: .5rem">Invoice</th>

            </tr>
        </thead>
        <tbody>

            @foreach ($members as $member)
                <tr>
                    <td>{{ $member->code }}</td>
                    <td>{{ $member->name }}</td>
                    <td>{{ $member->phone ?: '-' }}</td>
                    <td>{{ $member->email ?: '-' }}</td>
                    <td>{{ $member->address ?: '-' }}</td>
                    <td><button class="btn btn-badge bg-info text-white" data-bs-toggle="modal"
                            data-bs-target="#exampleModal"
                            wire:click="openModal('{{ $member->code }}')">{{ $member->invoices_count }}</button></td>

                </tr>
            @endforeach

        </tbody>
    </table>

    <!-- Modal -->
    <div wire:ignore.self class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Invoices</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @if ($data)
                        @foreach ($data as $invoice)
                            <div class="card mt-2">
                                <div wire:click="exportExcelDetail('{{ $invoice->no }}')" class="card-body"
                                    style="cursor: pointer;">
                                    <p>Invoice: {{ $invoice->no }}</p>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="custom-button1" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
