<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb mt-2">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Compare SO') }}
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Result') }}
                    </li>
                </ol>

                <div>
                    <button type="button" wire:click="export" class="custom-button1 btn-sm ml-4">Export Difference</button>
                    <button type="button" wire:click="exportNoDiff" class="custom-button1 btn-sm ml-4">Export No Difference</button>

                    <button wire:click="close" type="button" class="button-custom-secondary btn-sm ml-4">{{ __('Close') }}</button>
                </div>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin">
                <div class="">
                    <div class="card  p-3 mb-3">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Compare SO Result') }}</h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Date : ') }} <span class="">{{ $opnameh->date ?? '' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Type : ') }} <span class="">{{ $opnameh->type ?? '' }}</span></h6>
                        </div>
                    </div>

                    <div>
                        <div class="py-12">
                            <div class="table-responsive table-opname-result">
                                <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col">{{ __('Code') }}</th>
                                            <th scope="col">{{ __('Barcode') }}</th>
                                            <th scope="col">{{ __('Name') }}</th>
                                            <th scope="col">{{ __('Price') }}</th>
                                            <th scope="col">{{ __('OnHand') }}</th>
                                            <th scope="col">{{ __('Opname') }}</th>
                                            <th scope="col" style="border-top-right-radius: 1rem">{{ __('Difference') }}</th>
                                        </tr>
                                    </thead>

                                    <tbody class="small">
                                        @foreach($opnames as $key => $opname)
                                        <tr>
                                            <th scope="col">{{ $key + 1 }}</td>
                                            <td>{{ $opname->code }}</td>
                                            <td>{{ $opname->barcode }}</td>
                                            <td>{{ $opname->name }}</td>
                                            <td>{{ number_format($opname->price) }}</td>
                                            <td>{{ number_format($opname->onhand) }}</td>
                                            <td>{{ number_format($opname->opname) }}</td>
                                            <td>{{ number_format($opname->difference) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>
         Livewire.on('refreshDatatable', (params) => {
            $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
    </script>
</div>