<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center">
                <ol class="breadcrumb breadcrumb-opname pb-3 ">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Compare SO') }}
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Input') }}
                    </li>
                </ol>

                <div>
                    @if($isloading)
                    <button wire:click="firstClick" type="button" class="custom-button1 btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>
                    @else
                    <button wire:click="firstClick" type="button" class="custom-button1 btn-sm ml-4 rounded-3 fs-6 px-4 mt-3">{{ __('Import') }}</button>
                    @endif
                </div>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12" style="padding-top: 2rem">
                <div class="card p-lg-4 rounded-5 opname col-sm-12 col-md-12 col-lg-12 col-xl-12">
                    <div class="card-body" style="font-weight: bolder; font-size: medium;">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h6 class="card-title compare-so">{{ __('Compare SO Input') }}</h6>
                        </div>

                        <form class="">
                            <div class="mb-4">
                                <label for="soType" class="form-label">{{ __('Opname Type') }}</label>
                                <select wire:model="type" class="form-select form-select-md  opname-input" id="soType" name="soType">
                                    <option value="Global">{{ __('Global') }}</option>
                                    <option value="Partial">{{ __('Partial') }}</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label for="compareDate" class="form-label">{{ __('Stock Date') }}</label>
                                <input wire:model="period" type="date" class="form-control form-control-md " id="compareDate" name="compareDate" data-toggle="datepicker">
                            </div>

                            <div class="">
                                <label for="importFile" class="form-label">{{ __('Import File Opname *.csv') }}
                                </label>
                                <a wire:click="downloadTemplate" class="text-decoration-none badge bg-primary top-0 end-0" style="cursor: pointer;">Example</a>
                                <input wire:model="file" type="file" class="form-control  @error('file') is-invalid @enderror form-control-md" id="importFile" name="importFile" accept=".csv">
                                @error('file')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });

        document.addEventListener('livewire:navigated', () => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                $('#table').DataTable({
                    "bDestroy": true
                });
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>