<div>
    <div class="py-12 table-member">
        <div class="table-responsive table-member-tablet">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: 1rem;">#</th>
                        <th scope="col">{{ __('Code') }}</th>
                        <th scope="col">{{ __('Name') }}</th>
                        <th scope="col">{{ __('Hobby') }}</th>
                        <th scope="col">{{ __('Phone') }}</th>
                        <th scope="col">{{ __('Email') }}</th>
                        <th scope="col">{{ __('Address') }}</th>
                        <th scope="col" style="border-top-right-radius: 1rem;">{{ __('Status') }}</th>
                    </tr>
                </thead>

                <tbody class="small">
                    @foreach ($members as $key => $member)
                        <tr wire:key="{{ $member->code }}">
                            <th scope="col">{{ $key + 1 }}</td>
                            <td>{{ $member->code }}</td>
                            <td>{{ $member->name }}</td>
                            <td>{{ $member->hobby }}</td>
                            <td>{{ $member->phone }}</td>
                            <td>{{ $member->email }}</td>
                            <td>{{ $member->address }}</td>
                            <td>
                                {{-- <button class="btn @if ($member->active == 'Y') button-custom-success @else button-custom-danger @endif badge" data-bs-toggle="modal" data-bs-target="#modalStatus{{ $member->code }}"> --}}
                                <button
                                    class="@if ($member->active == 'Y') button-custom-success @else button-custom-danger @endif badge"
                                    data-bs-toggle="modal">

                                    @if ($member->active == 'N')
                                        INACTIVE
                                    @else
                                        ACTIVE
                                    @endif
                                </button>
                            </td>
                        </tr>
                        {{-- <!-- Modal -->
                    <div class="modal fade" id="modalStatus{{ $member->code }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                            <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Change Status Member</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                            <h3 class="text-center">{{ $member->name }}</h3>
                            </div>
                            <div class="modal-footer">
                            <button type="button" wire:click="updateStatus('{{ $member->code }}')" class="btn @if ($member->active == 'N') button-custom-success @else button-custom-danger @endif" data-bs-dismiss="modal">@if ($member->active == 'Y')
                                INACTIVE
                            @else
                                ACTIVE
                            @endif</button>
                            </div>
                        </div>
                        </div>
                    </div> --}}
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
</script>
