<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex breadcrumb-it-in" style="flex-direction: column">
                <ol class="breadcrumb mb-3">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Member') }}
                    </li>
                </ol>

                <div class="d-flex justify-start">
                    <a href="{{ route('welcome.register') }}" id="custom-button1" class="button-custom-primary">{{ __('Add New Member') }}</a>
                </div>

                <div class="mb-2 mt-1">
                    
                    @if($isloading)
                    <button type="button" wire:click="sapGetMember" wire:loading.attr="disabled" wire:target="sapGetMember" class="custom-button1 btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>
                    @else
                    <button wire:click="firstClickGetMember" wire:loading.attr="disabled" wire:target="firstClickGetMember" type="button" class="custom-button1 btn-sm ml-4">{{ __('Sync Data Member') }}</button>
                    <button wire:click="generateAndSaveQRCode" wire:loading.attr="disabled" wire:target="generateAndSaveQRCode" class="custom-button1 btn-sm ml-4">Generate Google QR</button>
                    @endif
                </div>
            </div>

        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="table-member border-white">
                    <div class="">
                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h6 class="card-title ">{{ __('') }}</h6>
                        </div>
                        @if($members->isEmpty())
                        <table id="example" class="my-table dataTables_wrapper dt-bootstrap5 text-white" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">{{ __('Code') }}</th>
                                    <th scope="col">{{ __('Name') }}</th>
                                    <th scope="col">{{ __('Phone') }}</th>
                                    <th scope="col">{{ __('Email') }}</th>
                                    <th scope="col">{{ __('Address') }}</th>
                                    <th scope="col">{{ __('Status') }}</th>
                                </tr>
                            </thead>
    
                        </table>
                        @else
                            <livewire:pos.member.member-table />
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });

        document.addEventListener('livewire:navigated', () => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                $('#table').DataTable({
                    "bDestroy": true
                });
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>