<div class="row justify-content-center pt-3">
    <div class="col">
        <div class="">
            <div {{-- @if ($isSuggestion) class="card-body head-table" @else  --}} class="card-body head-table-no-suggestion">
                {{-- @endif
                > --}}
                <table class="my-table" style="width:100%">
                    <thead>
                        <tr>
                            <th style="border-top-left-radius: .5rem">Code</th>
                            <th>Name</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center">Price</th>
                            <th class="text-center">Discount</th>
                            <th class="text-center" style="border-top-right-radius: .5rem">Sub Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($carts as $cart)
                            <tr wire:key="cart-{{ $cart['id'] }}">
                                <td style="font-weight: 500">{{ $cart['code'] }}</td>
                                <td data-bs-toggle="modal" data-bs-target="#modalCart" style="cursor: pointer">
                                    {{ $cart['name'] }}</td>
                                <td width="68px" class="stop-propagation">
                                    <input class="quantity-input @if ($cart['maxpack'] === 'N') border-0 @endif"
                                        type="number" id="{{ $cart['code'] }}"
                                        wire:change="sameCart({{ $cart['id'] }}, $event.target.value)"
                                        value="{{ $cart['qty'] }}" onchange="updateQuantity(this, {{ $cart['id'] }})"
                                        onpaste="handlePaste(event)" @if (!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])) min="1" @endif
                                        @if ($cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free') disabled @endif>
                                    {{-- @if ($cart['maxpack'] == 'N' || $cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free') disabled @endif> --}}


                                </td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['nprice'], 0, ',', '.') }}
                                </td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['nprice'] - $cart['price'], 0, ',', '.') }}</td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['price'] * $cart['qty'], 0, ',', '.') }}</td>

                            </tr>
                        @empty
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- <div class="" wire:key="{{ $refreshKey }}">
        @if ($isSuggestion)
            <div class="container mt-4">
                <h3 class="mb-4 text-center">{{ $suggestionName }}</h3>
                <div class="row">
                    @foreach ($suggestion as $index => $item)
                        <div class="col-md-3">
                            <div class="card border-0 shadow animate__animated" style="background-color: #EEF6F9"
                                x-data="{ isFadeOut: false }"
                                :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                x-transition:leave-end="opacity-0">
                                <div class="suggestion-card">
                                    <h6 class="suggestion">{{ $item['name'] }} ( Pack {{ $item['pack'] }} )</h6>
                                    <h6 class="suggestion">{{ $item['barcode'] }} </h6>
                                    @if ($index === 0)
                                        <div class="add-to-cart"
                                            wire:click="addSuggestionFirst('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                            @click="isFadeOut = true">
                                            Add to Cart
                                        </div>
                                    @else
                                        <div class="add-to-cart"
                                            wire:click="addSuggestion('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                            @click="isFadeOut = true">

                                            Add to Cart
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div> --}}

    {{-- <div class="">
            <div class="container mt-4">
                <h3 class="mb-4 text-center">Suggestion</h3>
                <div class="row">
                        <div class="col-md-4">
                            <div class="card border-0 shadow animate__animated"
                                x-data="{ isFadeOut: false }"
                                :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                x-transition:leave-end="opacity-0">
                                <div class="suggestion-card">
                                    <h6 class="suggestion">Item</h6>
                                    <h6 class="suggestion">Barcode </h6>
                                        <div class="add-to-cart"
                                            @click="isFadeOut = true">
                                            Add to Cart
                                        </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 shadow animate__animated"
                                x-data="{ isFadeOut: false }"
                                :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                x-transition:leave-end="opacity-0">
                                <div class="suggestion-card">
                                    <h6 class="suggestion">Item</h6>
                                    <h6 class="suggestion">Barcode </h6>
                                        <div class="add-to-cart"
                                            @click="isFadeOut = true">
                                            Add to Cart
                                        </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 shadow animate__animated"
                                x-data="{ isFadeOut: false }"
                                :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                x-transition:leave-end="opacity-0">
                                <div class="suggestion-card">
                                    <h6 class="suggestion">Item</h6>
                                    <h6 class="suggestion">Barcode </h6>
                                        <div class="add-to-cart"
                                            @click="isFadeOut = true">
                                            Add to Cart
                                        </div>
                                </div>
                            </div>
                        </div>
                </div>
            </div>
    </div> --}}

    <div style="border-radius: 0.25rem; margin-bottom: -3rem;">
        <div class="row body-charsier-3">
            <div class="col-lg-3 col-md-12 col-sm-12" x-data="{ selectedIndexSales: null }" x-init="selectedIndexSales = -1">
                <!-- Adjusted column size -->
                <div class="">
                    <div class="">
                        <div class="d-flex gap-1 align-items-center">
                            <label class="font-salesEmp">Sales Employee</label>
                            <h6 class="shortcut">F3</h6>
                        </div>
                        <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                            wire:model.live="form.sales" placeholder="No Sales Employee" hidden>
                        <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                            wire:model.debounce.100ms.live="searchsales" placeholder="No Sales Employee" autofocus
                            autocomplete="off"
                            @keydown.arrow-down.prevent="selectedIndexSales = Math.min(selectedIndexSales + 1, {{ count($sales) - 1 }})"
                            @keydown.arrow-up.prevent="selectedIndexSales = Math.max(selectedIndexSales - 1, -1)"
                            x-on:keydown.enter="
                                if(selectedIndexSales == -1) {
                                
                                } else {
                                    $wire.selectSales(selectedIndexSales);
                                    selectedIndexSales = -1; 
                                }">
                        @if ($selectedSales === null && $isDropdownsalesVisible)
                            <div class="dropdown-menu border-dark-subtle d-block py-0">
                                @foreach ($sales as $index => $sale)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexSales === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link" id="ddown-style"
                                                wire:click="selectSalesByClick('{{ $sale->code }}')"
                                                :class="{ 'text-white': selectedIndexSales === {{ $index }} }">
                                                {{ $sale->code }} || {{ $sale->name }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    {{-- <div class="col">
                        <div class="row text-primary" style="width: 400px">
                            <div class="col pt-4">
                                <p class="small text-muted mb-0 text-center">Total Qty</p>
                                <h3 class="mb-0 text-center" style="font-weight:600;">
                                    {{ $carttotal->sum('qty') }}
                                </h3>
                            </div>
                            <div class="col pt-4">
                                <p class="small text-muted mb-0 text-center">Sub Total</p>
                                <h3 class="mb-0" style="font-weight:600;">
                                    @if ($carttotal->isEmpty())
                                        Rp
                                    @else
                                        {{ 'Rp ' . number_format($carttotal->sum('total_price'), 0, ',', '.') }}
                                    @endif
                                </h3>
                            </div>
                        </div>
                    </div> --}}
                </div>
            </div>

            <div class="qty-grup col-lg-7 col-md-12 col-sm-12">
                <div class="qty-sub-2">
                    <div>
                        <p class="font-salesEmp">Quantity</p>
                        <h3 class="sub-total">
                            {{ $carttotal->sum('qty') }}
                        </h3>
                    </div>
                </div>

                <div class="qty-sub">
                    <div>
                        <p class="font-salesEmp">Sub Total</p>
                        <h3 class="sub-total">
                            @if ($carttotal->isEmpty())
                                Rp
                            @else
                                {{ 'Rp ' . number_format($carttotal->sum('total_price'), 0, ',', '.') }}
                            @endif
                        </h3>
                    </div>
                </div>
            </div>

            {{-- <div class="end-0 mx-5 mt-5 col-md-4 col-lg-6" wire:key="{{ $refreshKey }}">
                @if ($isSuggestion)
                    <div class="container mt-4">
                        <h3 class="mb-4 text-center">{{ $suggestionName }}</h3>
                        <div class="row">
                            @foreach ($suggestion as $index => $item)
                                <div class="col-md-6">
                                    <div class="card border-0 shadow animate__animated" style="background-color: #EEF6F9" x-data="{ isFadeOut: false }"
                                        :class="{ 'animate__fadeInRight': !isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                        x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                        x-transition:leave="animate__fadeOutLeft duration-300ms"
                                        x-transition:leave-end="opacity-0">
                                        <div class="card-body">
                                            <p class="card-text">{{ $item['name'] }} ( Pack {{ $item['pack'] }} )</p>
                                            <p class="card-text">{{ $item['barcode'] }}</p>
                                            @if ($index === 0)
                                                <button class="custom-button1 btn-block"
                                                    wire:click="addSuggestionFirst('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                                    @click="isFadeOut = true">Add to Cart</button>
                                            @else
                                                <button class="custom-button1 btn-block"
                                                    wire:click="addSuggestion('{{ $item['code'] }}', '{{ $item['no'] }}')"
                                                    @click="isFadeOut = true">Add to Cart</button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div> --}}

            <div class="col-lg-2 col-md-12 col-sm-12 text-primary text-right payment-button" style="">
                @if ($this->selectedSales === null)
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button" data-bs-target="#salesModal" data-bs-toggle="modal" class="button-try">
                            <div class="d-flex justify-content-center align-items-center gap-2">
                                <div class="text-white ">Pay</div>
                                <h6 class="fst-italic"
                                    style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                                    F4</h6>
                            </div>
                        </button>
                    </div>
                @else
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button"
                            @if (!empty($carts)) data-bs-toggle="modal" 
                        wire:click="createInvoiceOpen"
                        @else 
                        wire:click="cartEmpty" @endif
                            class="button-try">
                            <div class="d-flex justify-content-center align-items-center gap-2">
                                <div class="text-white ">Pay</div>
                                <h6 class="fst-italic"
                                    style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                                    F4</h6>
                            </div>
                        </button>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <input type="hidden" wire:keydown.window.shift.backspace="deleteLatestCart">
    <div wire:ignore.self class="modal fade" id="modalCart" tabindex="-1" aria-labelledby="modalCartLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCartLabel">Carts</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($carts as $cart)
                                <tr wire:key="cart-{{ $cart['id'] }}">
                                    <td>{{ $cart['code'] }}</td>
                                    <td>{{ $cart['name'] }}</td>
                                    <td>
                                        {{ 'Rp ' . number_format($cart['price'], 0, ',', '.') }}
                                    </td>
                                    <td width="80px">
                                        <input class="form-control form-control-sm quantity-input" type="number"
                                            id="{{ $cart['code'] }}"
                                            wire:change="sameCart({{ $cart['id'] }}, $event.target.value)"
                                            value="{{ $cart['qty'] }}"
                                            onchange="updateQuantity(this, {{ $cart['id'] }})"
                                            onpaste="handlePaste(event)"
                                            @if (!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])) min="1" @endif
                                            @if ($cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free') disabled @endif>
                                        {{-- @if ($cart['maxpack'] == 'N' || $cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free') disabled @endif> --}}

                                    </td>
                                    <td class="text-center">
                                        <button wire:click="deleteCart({{ $cart['id'] }})"
                                            wire:loading.attr="disabled" class="badge button-custom-danger"
                                            type="button"
                                            {{ $cart['benefit'] == 'Free' || $cart['benefit'] == 'Cheapest' ? 'disabled' : '' }}>
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center" width="100%">
                                    <td colspan="6">
                                        Empty
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts
<script>
    function updateQuantity(input, cartId) {
        var code = input.id;
        var quantity = parseInt(input.value);

        if (!code.startsWith('FG') && !code.startsWith('BUY') && !code.startsWith('VOUCHER')) {
            if (isNaN(quantity) || quantity < 1) {
                quantity = 1;
            }
        }
        input.value = quantity;
    }

    function handlePaste(event) {
        var clipboardData, pastedData;

        event.stopPropagation();
        event.preventDefault();

        clipboardData = event.clipboardData || window.clipboardData;
        pastedData = clipboardData.getData('Text');

        // Check if pasted data is a valid positive number
        var parsedValue = parseFloat(pastedData);
        if (!isNaN(parsedValue) && parsedValue >= 0) {
            // Update the input value
            var input = event.target;
            input.value = parsedValue;
            input.dispatchEvent(new Event('input'));
        }
    }

    window.addEventListener('keydown', function(event) {
        if (event.key === 'F3') {
            event.preventDefault();
            if (@this.modalOpen) {
                Livewire.dispatch('F3ModalOpen');
            } else {
                @this.salesModal();
            }
            console.log('press f3')
        }
        if (event.key === 'F4') {

            event.preventDefault();
            if (@this.isSalesModalVisible) {

            } else {
                if (@this.modalOpen) {
                    Livewire.dispatch('F4ModalOpen');
                } else {
                    if (@this.isCarts.length > 0) {
                        if (@this.selectedSales) {
                            @this.createInvoice();
                        } else {
                            @this.salesModal();
                        }
                    } else {
                        @this.cartEmpty();
                    }
                }
                console.log('press f4')
            }

        }
    });

    Livewire.on('createInvoice', () => {
        $('#invoiceModal').modal('show');
    });
    Livewire.on('closePayment', () => {
        $('#invoiceModal').modal('hide');
        Livewire.dispatch('resetPayment');
    });
</script>
