<div>
    <div class="form-group row">
        <div class="col-md-3">
            <label for="startDate">Start Date</label>
            <input type="date" class="form-control" id="startDate" wire:model="startDate" style="border-radius: 1rem">
        </div>
        <div class="col-md-3">
            <label for="endDate">End Date</label>
            <input type="date" class="form-control" id="endDate" wire:model="endDate" style="border-radius: 1rem">
        </div>
        <div class="col-md-2 mt-4">
            <button type="button" id="filterBtn" wire:click="toFilterActivities" wire:loading.attr="disabled"
                :class="{
                    'custom-button1 mb-2': !$wire.startDate || !$wire.endDate,
                    'btn btn-primary': $wire.startDate && $wire.endDate,
                    'btn btn-primary disabled': !$wire.startDate || !$wire.endDate
                }"
                :disabled="!$wire.startDate || !$wire.endDate">

                <span wire:loading.remove>Filter</span>
                <span wire:loading>
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                        aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                </span>
            </button>



        </div>

    </div>
    <div id="my-table-logs" class="mt-2">
        <table id="example" class="my-table" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center" style="border-top-left-radius: 1rem">Activity</th>
                    <th class="text-center">Description</th>
                    <th class="text-center">Caused By</th>
                    <th class="text-center">Before</th>
                    <th class="text-center">After</th>
                    <th class="text-center" style="border-top-right-radius: 1rem">Date</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($activities as $activity)
                    <tr>
                        <td class="text-center">{{ ucfirst($activity->event) }} {{ $activity->log_name }}</td>
                        <td>{{ $activity->description }}</td>
                        <td class="text-center">{{ $activity->causer->name }}</td>
                        @if ($activity->event === 'updated')
                            <td>
                                @if (is_array($activity->changes['old']))
                                    @if (isset($activity->changes['old']['qty']))
                                        Quantity : {{ $activity->changes['old']['qty'] }} <br>
                                    @endif

                                    @if (isset($activity->changes['old']['total_price']))
                                        Total Price : {{ $activity->changes['old']['total_price'] }} <br>
                                    @endif
                                @endif
                            </td>
                            <td>
                                @if (is_array($activity->changes['attributes']))
                                    @if (isset($activity->changes['attributes']['qty']))
                                        Quantity : {{ $activity->changes['attributes']['qty'] }} <br>
                                    @endif

                                    @if (isset($activity->changes['attributes']['total_price']))
                                        Total Price : {{ $activity->changes['attributes']['total_price'] }} <br>
                                    @endif
                                @endif
                            </td>
                        @else
                            <td>
                                @if (is_array($activity->changes['old']))
                                    @php
                                        $newKeys = [
                                            'code' => 'Code',
                                            'name' => 'Name',
                                            'price' => 'Price',
                                            'qty' => 'Quantity',
                                            'id_member' => 'Member',
                                            'total_price' => 'Total Price',
                                            'created_at' => 'Scanned',
                                        ];
                                    @endphp

                                    @foreach ($activity->changes['old'] as $key => $itemChange)
                                        @if ($key === 'created_at')
                                            {{ $newKeys[$key] }} :
                                            {{ \Carbon\Carbon::parse($itemChange)->format('l, d F Y, H:i:s') }} <br>
                                        @elseif(isset($newKeys[$key]))
                                            {{ $newKeys[$key] }} : {{ $itemChange }} <br>
                                        @else
                                            {{ $key }} : {{ $itemChange }} <br>
                                        @endif
                                    @endforeach
                                @endif
                            </td>
                            <td class="text-center">
                                Deleted
                            </td>
                        @endif

                        <td>{{ $activity->formatted_created_at }}</td>

                    </tr>
                @empty

                @endforelse
            </tbody>
        </table>
    </div>
</div>
@livewireScripts
<script>
    function handleLoadingState() {
        const buttonText = document.getElementById('buttonText');
        const loadingContent = document.getElementById('loadingContent');

        buttonText.style.display = 'none'; // Hide the "Filter" text
        loadingContent.style.display = 'inline'; // Show the loading spinner and text
    }

    Livewire.on('activityFiltered', () => {
        const buttonText = document.getElementById('buttonText');
        const loadingContent = document.getElementById('loadingContent');

        buttonText.style.display = 'inline'; // Show the "Filter" text
        loadingContent.style.display = 'none'; // Hide the loading spinner and text
    });

    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
</script>
