<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-192x192.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-512x512.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/apple-touch-icon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-16x16.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-32x32.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon.ico') }}" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Bestari Jaya</title>
    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="{{ asset('assets/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    @stack('styles')
    @livewireStyles
    <!-- Scripts -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body>
    <div id="app">
        {{-- <nav class="navbar navbar-expand-md navbar-expand-lg navbar-dark">
            <div class="container-fluid justify-content-center gap-2">
            <img src="{{ asset('assets/logo.png') }}" width="50" height="50" class="d-inline-block align-content-center" alt="">
              <a class="navbar-brand" href="{{ route('welcome.dashboard') }}">
                 POS PT Bestari Jaya</a>
              <a id="toggleThemeButton">
                <span id="themeIcon" class="bi bi-moon-fill fs-5"></span>
            </a>
        </nav> --}}
        <main class="">
            @yield('content')

            <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>

            <x-livewire-alert::scripts />
        </main>
    </div>

    <!-- Include jQuery -->
    <script src="{{ asset('assets/js/jquery-3.7.0.js') }}"></script>

    <!-- Include DataTables core script -->
    <script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>

    <!-- Include DataTables Bootstrap 5 extension script -->
    <script src="{{ asset('assets/js/dataTables.bootstrap5.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            var table = $('#example').DataTable();


            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            const currentTheme = localStorage.getItem('theme') ||
            'light'; // Get the stored theme or default to 'light'
            document.documentElement.setAttribute('data-bs-theme', currentTheme);

            // Set the icon based on the theme
            const themeIcon = document.getElementById('themeIcon');
            if (currentTheme === 'dark') {
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }
        });

        const toggleThemeButton = document.getElementById('toggleThemeButton');
        toggleThemeButton.addEventListener('click', () => {
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            let newTheme = 'light';

            if (currentTheme === 'light') {
                newTheme = 'dark';
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                newTheme = 'light';
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }

            document.documentElement.setAttribute('data-bs-theme', newTheme);
            localStorage.setItem('theme', newTheme); // Store the theme in local storage
        });
    </script>
    @stack('scripts')
</body>

</html>
