@extends('layouts.header')

@section('content')
<style>
    .container .row .card {
     width: 500px;
     margin: 30px;
     overflow: hidden;
 }

 .container .row .card .card-body {
     padding: 1rem 1.2rem;
 }

 .container .row .card .card-body .card-img img {
     width: 60px;
     height: 60px;
     object-fit: cover;
     transform: translateY(50px);
     transition: 0.5s;
     border-radius: 50%
 }

 .container .row .card .card-body .name {
     transform: translateY(50px);
     transition: 0.5s
 }

 .btn-register {
     background-color: #007bff;
     color: #fff;
     border: none;
     border-radius: 20px;
     padding: 10px 20px;
     font-size: 1rem;
     cursor: pointer;
     transition: background-color 0.3s ease;
 }

 .btn-register:hover {
     background-color: #0056b3;
 }
 
 .form-label {
     font-size: 0.9rem;
     font-weight: bold;
     margin-bottom: 0.5rem;
     /* Text shadow */
     text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
 }

 .form-control {
     border: none;
     border-radius: 20px;
     padding: 12px 15px;
     box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
     transition: box-shadow 0.3s ease;
 }

 .form-control:focus {
     outline: none;
     box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.2);
 }
 body {
   height: 100vh;
   display: flex;
   justify-content: center;
   align-items: center;
   margin: 0; /* Remove default margin */
   padding: 0; /* Remove default padding */
   font-family: 'Poppins', sans-serif;
   background: radial-gradient(circle, var(--cashier-color) 1%, transparent 5%),
               radial-gradient(circle, var(--cashier-color) 1%, transparent 3%);
   background-size: 30px 30px; /* Ukuran polkadot */
   background-position: 0 0, 15px 15px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        
        <div class="col-lg-12 p-lg-5 shadow-sm login-card">  
            <div class="logo-home text-center mb-3">
                <img src="{{asset('assets/SoftComp - Logo-01.png')}}" width="130px" height="50px" alt="Deskripsi Gambar">
            </div>  
            {{-- <div class="card-header">
                <h1 class="card-title text-center fw-bolder fs-4">Register</h1>
            </div> --}}
            @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
            @endif
            @if (session('danger'))
            <div class="alert alert-danger" role="alert">
                {{ session('danger') }}
            </div>
            @endif
            <div class="card-body">
                <form method="POST" action="{{ route('member.store') }}">
                    @csrf

                    <div class="row mb-3">
                        <label for="name" class="col-md-4 col-form-label text-md-end login-text">{{ __('Name') }}</label>

                        <div class="col-md-6">
                            <input id="name" type="text" class="rounded-pill form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" placeholder="Name" autofocus>

                            @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label for="email" class="col-md-4 col-form-label text-md-end login-text">{{ __('Email Address') }}</label>

                        <div class="col-md-6">
                            <input id="email" type="email" class="rounded-pill form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" placeholder="Email" required autocomplete="email">

                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="address" class="col-md-4 col-form-label text-md-end login-text">{{ __('Address') }}</label>

                        <div class="col-md-6">
                            <input id="address" type="address" class="rounded-pill form-control @error('address') is-invalid @enderror"  placeholder="Jl. Atlanta" name="address" required >

                            @error('address')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="phone" class="col-md-4 col-form-label text-md-end login-text">{{ __('Phone') }}</label>

                        <div class="col-md-6">
                            <input id="phone" type="phone" class="rounded-pill form-control @error('phone') is-invalid @enderror"  placeholder="+628****" name="phone" required >

                            @error('phone')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    

                    <div class="row mb-3">
                        <label for="password" class="col-md-4 col-form-label text-md-end login-text">{{ __('Password') }}</label>

                        <div class="col-md-6">
                            <input id="password" type="password" class="rounded-pill form-control @error('password') is-invalid @enderror"  placeholder="••••••••" name="password" required autocomplete="new-password">

                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label for="password-confirm" class="col-md-4 col-form-label text-md-end login-text">{{ __('Confirm Password') }}</label>

                        <div class="col-md-6">
                            <input id="password-confirm" type="password" class="rounded-pill form-control" name="password_confirmation" placeholder="••••••••" required autocomplete="new-password">
                        </div>
                    </div>

                    <div class="row text-center">
                        <div class="card-header">
                            <button type="submit" class="custom-button1 rounded-pill py-2 px-4">
                                {{ __('Register') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
