<?php

namespace App\Mail;

use App\Models\Settings;
use App\Models\Warehouse;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;

class SandboxMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public $sandboxInvoices;
    public $warehouse;
    public function __construct($sandboxInvoices)
    {
        $this->sandboxInvoices = $sandboxInvoices;
        $user = Auth::user();
        $warehouse = Warehouse::where('code', $user->whs_code)->first();
        $this->warehouse = $warehouse;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Sandbox Mail',
        );
    }

    public function build()
    {
        return $this->view('report.reportsandbox', ['sandboxInvoices' => $this->sandboxInvoices]);
    }
}
