<?php

namespace App\Livewire\Settings;

use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class Form extends Component
{
    use LivewireAlert;

    public $setting;
    public $printername;
    public $wh_name;
    public $address;
    public $phone;
    public $email;
    public $receipt_footer;
    public $url_admin;

    public function render()
    {
        $setting = $this->setting;
        $footer = str_replace('\n', "\n", $setting->receipt_footer);
        $footer = nl2br($footer);

        return view('livewire.settings.form', compact('footer'));
    }

    public function mount()
    {
        $user = Auth::user();
        $setting = Settings::first();
        $this->setting = $setting;
        $this->printername = $setting->printer_name;
        $this->wh_name = $setting->wh_name;
        $this->address = $setting->address;
        $this->phone = $setting->phone;
        $this->email = $setting->email;
        $this->receipt_footer = nl2br($setting->receipt_footer);
        $this->url_admin = $setting->url_admin;
    }

    public function save()
    {
        $user = Auth::user();
        $whs_code = $user->whs_code;
        $setting = $this->setting;
        $setting->update([
            'wh_code' => $whs_code,
            'printer_name' => $this->printername,
            'wh_name' => $this->wh_name,
            'address' => $this->address,
            'phone' => $this->phone,
            'email' => $this->email,
            'url_admin' => $this->url_admin,
            'receipt_footer' => str_replace("\n", '\\n', $this->receipt_footer), // Replace '\n' with '\\n'
        ]);

        $this->alert('success', 'Setting updated Succesfully', [
            'position' => 'top',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }
}
