<?php

namespace App\Livewire\Returnsale;

use App\Livewire\Returnsale\Table;
use App\Models\Auths;
use App\Models\Invoice as ModelsInvoice;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Jantinnerezo\LivewireAlert\LivewireAlert;


class Transactionreturn extends Component
{
    use LivewireAlert;

    public $selectedInvoice = null;
    public $search = "";
    public $selectedCarts = [];
    public $selectedItems = [];

    public function selectInvoiceByName()
    {
        $user = Auth::user();

        $authorization = Auths::where('menu', 'Transaction')
            ->where('modul', 'Sales Return')->first(); // Fetch the specific authorization

        $hasPermission = $user->authorizations
            ->filter(function ($authorization) {
                return strpos($authorization->auth, 'C') !== false;
            })
            ->contains('id_auth', $authorization->id);
        if ($hasPermission) {
            $invoice = ModelsInvoice::where('no', $this->search)
                ->whereNull('no_inv')->first();
            if ($invoice) {
                $detailInvoice = ModelsInvoice::where('no_inv', $this->search)->first();

                if ($detailInvoice) {
                    $this->alert('warning', 'Invoice Already Returned', [
                        'position' => 'top',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $this->selectedCarts = $invoice->detailInvoices; // Assuming you have a relationship set up between invoices and carts
                    $this->selectedItems = [];
                    $this->dispatch('selectedCartsReceived', data: $this->selectedCarts, datas: $this->selectedItems)->to(Table::class);
                }
            } else {
                $this->alert('error', 'Invoice Not Found', [
                    'position' => 'top',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            abort(403);
        }
    }


    public function render()
    {
        return view('livewire.returnsale.transactionreturn');
    }
}
