<?php

namespace App\Livewire\Returnsale;

use App\Models\Cart;
use Livewire\Attributes\On;
use Livewire\Component;

class Returntable extends Component
{
    public $sales;
    public $member;
    public $data;
    public $carts;
    public $isButtonDisabled = false;

    public function render()
    {
        return view('livewire.returnsale.returntable');
    }

    #[On('newData')]
    public function mount($data)
    {
       $this->data = $data;
       $this->carts = Cart::where('id_user', auth()->user()->id)
       ->orderBy('grouping', 'desc')
       ->orderBy('promo', 'desc')
       ->orderBy('pack', 'asc')
       ->get();
    }

    public function toCancel()
    {
        $this->isButtonDisabled = true;
        $this->dispatch('clickCancel');
    }

    #[On('clickCancel')]
    public function cancel()
    {
        sleep(1);
        return redirect()->route('welcome.returnsale');
    }
}
