<?php

namespace App\Livewire\Report;

use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportMemberTransaction;
use App\Mail\MyTestMail;
use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Member;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class Transactionmember extends Component
{
    public $startDate;
    public $endDate;
    public $members;
    public $selectedDate;
    public $dataDetail;

    public function mount()
    {
        $members = Member::with(['invoices' => function ($query) {
            if ($this->startDate && $this->endDate) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            } elseif ($this->startDate) {
                $query->whereDate('created_at', '=', $this->startDate);
            } elseif ($this->endDate) {
                $query->whereDate('created_at', '<=', $this->endDate);
            }
        }])
        ->withCount(['invoices' => function ($query) {
            if ($this->startDate && $this->endDate) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            } elseif ($this->startDate) {
                $query->whereDate('created_at', '=', $this->startDate);
            } elseif ($this->endDate) {
                $query->whereDate('created_at', '<=', $this->endDate);
            }
        }])
        ->orderBy('invoices_count', 'desc')
        ->get();
    
        $members = $members->where('invoices_count', '>', 0);
        $this->members = $members;
    }

    public function filters()
    {
        $members = Member::with(['invoices' => function ($query) {
            if ($this->startDate && $this->endDate) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            } elseif ($this->startDate) {
                $query->whereDate('created_at', '=', $this->startDate);
            } elseif ($this->endDate) {
                $query->whereDate('created_at', '<=', $this->endDate);
            }
        }])
        ->withCount(['invoices' => function ($query) {
            if ($this->startDate && $this->endDate) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            } elseif ($this->startDate) {
                $query->whereDate('created_at', '=', $this->startDate);
            } elseif ($this->endDate) {
                $query->whereDate('created_at', '<=', $this->endDate);
            }
        }])
        ->orderBy('invoices_count', 'desc')
        ->get();
        $members = $members->where('invoices_count', '>', 0);
        
        if ($members->isEmpty()) {
            $members = Member::withCount('invoices')->orderBy('invoices_count', 'desc')->get();
            $members = $members->where('invoices_count', '>', 0);
            $this->members = $members;
        }

        $this->members = $members;

    }

    public function clearfilters()
    {
        $members = Member::withCount('invoices')->orderBy('invoices_count', 'desc')->get();
        $members = $members->where('invoices_count', '>', 0);
        $this->startDate = '';
        $this->endDate = '';
        $this->members = $members;
    }
    

    public function exportExcel()
    {
        //Get member with invoices
        
            $members = Member::with(['invoices' => function ($query) {
                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);
                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);
                }
            }])
            ->withCount(['invoices' => function ($query) {
                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);
                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);
                }
            }])
            ->orderBy('invoices_count', 'desc')
            ->get();

        // $members = Member::withCount(['invoices' => function ($query) {
        //     if ($this->startDate && $this->endDate) {
        //         $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        //     } elseif ($this->startDate) {
        //         $query->whereDate('created_at', '=', $this->startDate);
        //     } elseif ($this->endDate) {
        //         $query->whereDate('created_at', '<=', $this->endDate);
        //     }
        // }])->orderBy('invoices_count', 'desc')->get();
        $members = $members->where('invoices_count', '>', 0);

        $this->members = $members;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if($this->startDate === null){
            $filename = "Member Transaction Report - {$now}.xlsx";
        }else{
            $filename = "Member Transaction Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        return Excel::download(new ExportMemberTransaction($members), $filename);

    }

    public function openModal($code)
    {   
        $members = Member::withCount(['invoices' => function ($query) {
            if ($this->startDate && $this->endDate) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            } elseif ($this->startDate) {
                $query->whereDate('created_at', '=', $this->startDate);
            } elseif ($this->endDate) {
                $query->whereDate('created_at', '<=', $this->endDate);
            }
        }])->orderBy('invoices_count', 'desc')->get();
    
        $members = $members->where('invoices_count', '>', 0);
        $this->members = $members;

        $data = Invoice::where('id_member', $code)
        ->when($this->startDate && $this->endDate, function ($query) {
            $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        })
        ->when($this->startDate && !$this->endDate, function ($query) {
            $query->whereDate('created_at', '=', $this->startDate);
        })
        ->when(!$this->startDate && $this->endDate, function ($query) {
            $query->whereDate('created_at', '<=', $this->endDate);
        })
        ->get();
        $data->load('detailInvoices');

        $this->dataDetail = $data;
    }

    public function exportExcelDetail($code)
    {        
        $data = DetailInvoice::where('invoice', $code)->get();
        $invoicesdetail = $data;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if($this->startDate === null){
            $filename = "Member Invoice Detail Report - {$now}.xlsx";
        }else{
            $filename = "Member Invoice Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        return Excel::download(new ExportInvoiceDetail($invoicesdetail), $filename);
    }

    public function render()
    {
        return view('livewire.report.transactionmember',[
            'members' => $this->members,
            'data' => $this->dataDetail,
        ]);
    }
}
