<?php

namespace App\Livewire\Pos\It\ItReqOut;

use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class ItReqOutDetail extends Component
{
    public $no;
    public $details;
    public $noit;

    public function render()
    {
        return view('livewire.pos.it.it-req-out.it-req-out-detail');
    }

    public function mount($it)
    {
        $this->noit = $it;
        $this->details = DB::table('Luv2_it_req_out_detail')
            ->Join('Luv2_it_req_out', 'Luv2_it_req_out_detail.no', '=', 'Luv2_it_req_out.no')
            ->Join('Luv2_item', 'Luv2_it_req_out_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_req_out_detail"."qty") as "qty"'), DB::raw('SUM("Luv2_it_req_out_detail"."qty_send") as "qty_send"'))
            ->where('Luv2_it_req_out.no', $it)
            ->groupBy('Luv2_item.code')
            ->get();
       
        $this->no = DB::table('Luv2_it_req_out')
            ->where('no', $it)->first();
    }

    #[On('toRedirect')]
    public function close()
    {
        return redirect()->route('it.itreqout');
    }
}
