<?php

namespace App\Livewire\Pos\It\ItReqIn;

use App\Models\Settings;
use App\Traits\GetItemITRTraits;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class SyncReq extends Component
{
    use LivewireAlert;
    use GetItemITRTraits;

    public $startDate;
    public $endDate;
    public $docNum;
    public $isloading = false;
    public $isCheckedAll = true;
    public $isPeriod = false;
    public $isDocnum = false;
    public $selectedFilter;

    public function render()
    {
        return view('livewire.pos.it.itreqin.sync-req');
    }

    protected function isConnectionResetError($e)
    {
        return $e instanceof \GuzzleHttp\Exception\RequestException &&
            strpos($e->getMessage(), 'cURL error 56: Recv failure: Connection was reset') !== false;
    }

    protected function reDoFunction($function, $args = [])
    {
        call_user_func_array([$this, $function], $args);
    }

    public function mount()
    {
        $this->startDate = Carbon::now()->toDateString();
        $this->endDate = Carbon::now()->toDateString();
    }

    public function updatedIsCheckedAll($value)
    {
        if ($value) {
            $this->isPeriod = false;
            $this->isDocnum = false;
        } else {
            $this->isPeriod = true;
        }
    }
    public function updatedSelectedFilter($value)
    {
        if ($value === 'Period') {
            $this->isPeriod = true;
            $this->isDocnum = false;
        } elseif ($value === 'Docnum') {
            $this->isPeriod = false;
            $this->isDocnum = true;
        }
    }

    public function firstClick()
    {

        $this->isloading = true;
        if ($this->isPeriod && !$this->isDocnum && !$this->isCheckedAll) {
            $this->dispatch('filterItReq');
        } elseif (!$this->isPeriod && $this->isDocnum && !$this->isCheckedAll) {
            $this->dispatch('filterItReq');
        } elseif ($this->isCheckedAll && !$this->isDocnum && !$this->isPeriod) {
            $this->dispatch('notFilterItReq');
        } else {
        }
    }

    #[On('notFilterItReq')]
    public function sapGetItReq()
    {
        set_time_limit(2000);
        $this->isloading = true;
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $userId = auth()->user()->id;
        $url = $setting->url;
        $whscode = $setting->wh_code;

        try {
            $response = Http::post($url . '/api/search', [
                "Select" => "b.\"WhsCode\" as \"whs_code\",b.\"FromWhsCod\" as \"whs_code_from\", TO_CHAR(a.\"DocDate\", 'yyyy-MM-dd') as \"date\",a.\"Comments\" as \"comments\" ,a.\"DocEntry\" as \"entry\",a.\"DocNum\" as \"no\",a.\"CANCELED\" as \"canceled\",'" . $userId . "' as \"id_user\" ",
                "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"CANCELED\" = 'N' and a.\"DocStatus\" = 'O' group by b.\"WhsCode\", b.\"FromWhsCod\", a.\"DocDate\", a.\"Comments\", a.\"DocEntry\", a.\"DocNum\", a.\"CANCELED\""
            ]);

            $responseDet = Http::post($url . '/api/search', [
                "Select" => "b.\"WhsCode\" as \"whs_code\",a.\"DocDate\" as \"date\",a.\"CANCELED\" \"canceled\",a.\"DocNum\" as \"no\",b.\"ItemCode\" as \"item_code\",b.\"Quantity\" as \"qty\",b.\"LineNum\" as \"linenum\",'" . $userId . "' as \"id_user\",c.\"CodeBars\" as \"item_barcode\",c.\"ItemName\" as \"item_name\",c.\"ItmsGrpCod\" as \"item_group_code\" ",
                "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join OITM c on b.\"ItemCode\"=c.\"ItemCode\"",
                "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"CANCELED\" = 'N' and a.\"DocStatus\" = 'O'",
            ]);
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('sapGetItReq');
            }
        }

        if ($response->successful() && $responseDet->successful()) {
            $jsonData = $response->json();
            $jsonDataDet = $responseDet->json();
            if (!empty($jsonData)) {
                if ($jsonData[0]['whs_code'] != '') {
                    DB::table('Luv2_it_req_temp')->where('id_user', $userId)->delete();
                    $chunks = array_chunk($jsonData, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $it) {
                            $insertData[] = [
                                'whs_code' => $it['whs_code'],
                                'whs_code_from' => $it['whs_code_from'],
                                'date' => $it['date'],
                                'comments' => $it['comments'],
                                'no' => $it['no'],
                                'entry' => $it['entry'],
                                'canceled' => $it['canceled'],
                                'id_user' => $it['id_user'],
                            ];
                        }
                        DB::table('Luv2_it_req_temp')->insert($insertData);
                    }

                    $chunks = array_chunk($jsonDataDet, 1000);

                    foreach ($chunks as $chunk) {
                        $insertDataDet = [];

                        foreach ($chunk as $item) {
                            $insertDataDet[] = [
                                'no' => $item['no'],
                                'item_code' => $item['item_code'],
                                'qty' => $item['qty'],
                                'qty_receive' => $item['qty'],
                                'linenum' => $item['linenum'],
                                'id_user' => $item['id_user'],
                                'whs_code' => $item['whs_code'],
                                'date' => $item['date'],
                                'canceled' => $item['canceled'],
                            ];
                        }

                        DB::table('Luv2_it_req_detail_temp')->insert($insertDataDet);
                    }

                    #insert it
                    DB::statement("
                    INSERT INTO \"Luv2_it_req\" (\"whs_code\", \"whs_code_from\", \"date\", \"comments\", \"no\", \"canceled\", \"id_user\", \"entry\") 
                    SELECT \"whs_code\", \"whs_code_from\", \"date\", \"comments\", \"no\", \"canceled\", '" . $userId . "', \"entry\"
                    FROM \"Luv2_it_req_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_it_req\" WHERE \"Luv2_it_req\".\"no\" = \"Luv2_it_req_temp\".\"no\"
                    ) and \"Luv2_it_req_temp\".\"id_user\"='" . $userId . "' 
                ");

                    #update it
                    DB::statement("
                    UPDATE \"Luv2_it_req\"
                    SET \"canceled\"=\"Luv2_it_req_temp\".\"canceled\"
                    FROM \"Luv2_it_req_temp\"
                    WHERE \"Luv2_it_req_temp\".\"no\"=\"Luv2_it_req\".\"no\"
                    AND \"Luv2_it_req_temp\".\"canceled\"<>\"Luv2_it_req\".\"canceled\";
                ");

                    #insert it det
                    DB::statement("
                    INSERT INTO \"Luv2_it_req_detail\" (\"no\", \"item_code\", \"qty\", \"qty_receive\", \"linenum\") 
                    SELECT \"no\", \"item_code\", \"qty\", \"qty_receive\", \"linenum\"
                    FROM \"Luv2_it_req_detail_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_it_req_detail\" WHERE \"Luv2_it_req_detail\".\"no\" = \"Luv2_it_req_detail_temp\".\"no\" and \"Luv2_it_req_detail\".\"linenum\" = \"Luv2_it_req_detail_temp\".\"linenum\"
                    ) and \"Luv2_it_req_detail_temp\".\"id_user\"='" . $userId . "' 
                ");


                    DB::table('Luv2_it_req_temp')->where('id_user', $userId)->delete();
                    DB::table('Luv2_it_req_detail_temp')->where('id_user', $userId)->delete();

                    $this->alert('success', 'Data IT Req synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('getItem');
                    // $this->dispatch('disableButton');
                    // $this->dispatch('redirectTo');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('disableButton');
                    $this->dispatch('redirectTo');
                }
            } else {
                $this->alert('info', 'Theres no data to synchrone', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('disableButton');
                $this->dispatch('redirectTo');
            }
        }
    }


    #[On('filterItReq')]
    public function sapGetItReqisFilter()
    {
        $this->isloading = true;

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $userId = auth()->user()->id;
        $url = $setting->url;
        $whscode = $setting->wh_code;
        try {
            if ($this->isPeriod) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "b.\"WhsCode\" as \"whs_code\",b.\"FromWhsCod\" as \"whs_code_from\", TO_CHAR(a.\"DocDate\", 'yyyy-MM-dd') as \"date\",a.\"Comments\" as \"comments\" ,a.\"DocEntry\" as \"entry\",a.\"DocNum\" as \"no\",a.\"CANCELED\" as \"canceled\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by b.\"WhsCode\", b.\"FromWhsCod\", a.\"DocDate\", a.\"Comments\", a.\"DocEntry\", a.\"DocNum\", a.\"CANCELED\"",
                    // "Where" => "\"ToWhsCode\"='" . $whscode . "' and \"DocDate\" = '" . $this->startDate . "'",
                ]);

                $responseDet = Http::post($url . '/api/search', [
                    "Select" => "b.\"WhsCode\" as \"whs_code\",a.\"DocDate\" as \"date\",a.\"CANCELED\" \"canceled\",a.\"DocNum\" as \"no\",b.\"ItemCode\" as \"item_code\",b.\"Quantity\" as \"qty\",b.\"LineNum\" as \"linenum\",'" . $userId . "' as \"id_user\",c.\"CodeBars\" as \"item_barcode\",c.\"ItemName\" as \"item_name\",c.\"ItmsGrpCod\" as \"item_group_code\" ",
                    "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join OITM c on b.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "'",
                    // "Where" => "\"ToWhsCode\"='" . $whscode . "' and \"DocDate\" = '" . $this->startDate . "'",

                ]);
            } elseif ($this->isDocnum) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "b.\"WhsCode\" as \"whs_code\",b.\"FromWhsCod\" as \"whs_code_from\", TO_CHAR(a.\"DocDate\", 'yyyy-MM-dd') as \"date\",a.\"Comments\" as \"comments\" ,a.\"DocEntry\" as \"entry\",a.\"DocNum\" as \"no\",a.\"CANCELED\" as \"canceled\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"DocNum\" = '" . $this->docNum . "' group by b.\"WhsCode\", b.\"FromWhsCod\", a.\"DocDate\", a.\"Comments\", a.\"DocEntry\", a.\"DocNum\", a.\"CANCELED\"",
                ]);

                $responseDet = Http::post($url . '/api/search', [
                    "Select" => "b.\"WhsCode\" as \"whs_code\",a.\"DocDate\" as \"date\",a.\"CANCELED\" \"canceled\",a.\"DocNum\" as \"no\",b.\"ItemCode\" as \"item_code\",b.\"Quantity\" as \"qty\",b.\"LineNum\" as \"linenum\",'" . $userId . "' as \"id_user\",c.\"CodeBars\" as \"item_barcode\",c.\"ItemName\" as \"item_name\",c.\"ItmsGrpCod\" as \"item_group_code\" ",
                    "From" => "OWTQ a inner join WTQ1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join OITM c on b.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and a.\"DocNum\" = '" . $this->docNum . "'",
                ]);
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('sapGetItReqisFilter');
            }
        }

        if ($response->successful() && $responseDet->successful()) {
            $jsonData = $response->json();
            $jsonDataDet = $responseDet->json();
            if ($jsonData[0]['whs_code'] !== '') {
                DB::table('Luv2_it_req_temp')->where('id_user', $userId)->delete();
                $chunks = array_chunk($jsonData, 1000);
                foreach ($chunks as $chunk) {
                    $insertData = [];
                    foreach ($chunk as $it) {
                        $insertData[] = [
                            'whs_code' => $it['whs_code'],
                            'whs_code_from' => $it['whs_code_from'],
                            'date' => $it['date'],
                            'comments' => $it['comments'],
                            'no' => $it['no'],
                            'entry' => $it['entry'],
                            'canceled' => $it['canceled'],
                            'id_user' => $it['id_user'],
                        ];
                    }
                    DB::table('Luv2_it_req_temp')->insert($insertData);
                }

                $chunks = array_chunk($jsonDataDet, 1000);

                foreach ($chunks as $chunk) {
                    $insertDataDet = [];

                    foreach ($chunk as $item) {
                        $insertDataDet[] = [
                            'no' => $item['no'],
                            'item_code' => $item['item_code'],
                            'qty' => $item['qty'],
                            'qty_receive' => $item['qty'],
                            'linenum' => $item['linenum'],
                            'id_user' => $item['id_user'],
                            'whs_code' => $item['whs_code'],
                            'date' => $item['date'],
                            'canceled' => $item['canceled'],
                        ];
                    }

                    DB::table('Luv2_it_req_detail_temp')->insert($insertDataDet);
                }

                #insert it
                DB::statement("
                INSERT INTO \"Luv2_it_req\" (\"whs_code\", \"whs_code_from\", \"date\", \"comments\", \"no\", \"canceled\", \"id_user\", \"entry\") 
                SELECT \"whs_code\", \"whs_code_from\", \"date\", \"comments\", \"no\", \"canceled\", '" . $userId . "', \"entry\"
                    FROM \"Luv2_it_req_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_it_req\" WHERE \"Luv2_it_req\".\"no\" = \"Luv2_it_req_temp\".\"no\"
                    ) and \"Luv2_it_req_temp\".\"id_user\"='" . $userId . "' 
                ");

                #update it
                DB::statement("
                    UPDATE \"Luv2_it_req\"
                    SET \"canceled\"=\"Luv2_it_req_temp\".\"canceled\"
                    FROM \"Luv2_it_req_temp\"
                    WHERE \"Luv2_it_req_temp\".\"no\"=\"Luv2_it_req\".\"no\"
                    AND \"Luv2_it_req_temp\".\"canceled\"<>\"Luv2_it_req\".\"canceled\";
                ");

                #insert it det
                DB::statement("
                    INSERT INTO \"Luv2_it_req_detail\" (\"no\", \"item_code\", \"qty\", \"qty_receive\", \"linenum\") 
                    SELECT \"no\", \"item_code\", \"qty\", \"qty_receive\", \"linenum\"
                    FROM \"Luv2_it_req_detail_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_it_req_detail\" WHERE \"Luv2_it_req_detail\".\"no\" = \"Luv2_it_req_detail_temp\".\"no\" and \"Luv2_it_req_detail\".\"linenum\" = \"Luv2_it_req_detail_temp\".\"linenum\"
                    ) and \"Luv2_it_req_detail_temp\".\"id_user\"='" . $userId . "' 
                ");


                DB::table('Luv2_it_req_temp')->where('id_user', $userId)->delete();
                DB::table('Luv2_it_req_detail_temp')->where('id_user', $userId)->delete();

                $this->alert('success', 'Data IT Req synchrone succesfully', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('getItem');

                // $this->dispatch('disableButton');
                // $this->dispatch('redirectTo');
            } else {
                $this->alert('info', 'Theres no data to synchrone', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('disableButton');
                $this->dispatch('redirectTo');
            }
        }
    }

    #[On('getItem')]
    public function syncItems()
    {
        if ($this->isPeriod) {
            $this->getItemWithFilter();
        } elseif ($this->isDocnum) {
            $this->getItemWhereDocnum();
        } else {
            $this->getItem();
        }
    }

    #[On('redirectTo')]
    public function toredirect()
    {
        sleep(2);
        return redirect()->route('it.itreq');
    }
}
