<?php

namespace App\Livewire\Pos\It\ItReqIn;

use App\Mail\ItRequestMail;
use App\Models\ItReq;
use App\Models\Settings;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class ItreqTable extends Component
{
    public $no;
    public $noit;
    public $isloading;

    use LivewireAlert;

    public function render()
    {
        $its = ItReq::with(['whsFrom', 'details'])
        ->where('canceled', 'N')
        ->withSum('details', 'qty')
            ->orderBy('Luv2_it_req.date', 'desc')
            ->orderBy('Luv2_it_req.no', 'desc')
            ->get();

            $totalSumQty = $its->sum('details_sum_qty');
        return view('livewire.pos.it.itreqin.itreq-table', compact('its', 'totalSumQty'));
    }

    public function detail($it)
    {
        return redirect()->route('it_req_detail', ['it' => $it]);
    }

    #[On('refresh')]
    public function updated()
    {
    }
    
    public function sendEmailItReq($it)
    {
        $user = Auth::user();
        $toko = Settings::where('wh_code', $user->whs_code)->first();
        $email = $toko->email_sandbox;
        $this->noit = $it;
        $this->no = DB::table('Luv2_it_req')
            ->where('no', $it)->first();
        $itemSelisih = DB::table('Luv2_it_req_detail as detail')
            ->join('Luv2_it_req', 'detail.no', '=', 'Luv2_it_req.no')
            ->join('Luv2_item', 'detail.item_code', '=', 'Luv2_item.code')
            ->select(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
                DB::raw('SUM(detail.qty) as qty'),
                DB::raw('SUM(detail.qty_receive) as qty_receive')
            )
            ->where('Luv2_it_req.no', $this->noit)
            ->groupBy('Luv2_item.code')
            ->havingRaw('SUM(detail.qty) <> SUM(detail.qty_receive)')
            ->get();
        $header = $this->no;
        Mail::to($email)->send(new ItRequestMail($itemSelisih, $header));
        $this->alert('success', 'Email sent succesfully!', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'width' => '400',
            'timerProgressBar' => true,
        ]);

        $this->dispatch('refreshjs');
    }

    public function firstClick($it)
    {
        $this->isloading = true;
        $this->dispatch('toSyncITReq', $it);
    }

    #[On('toSyncITReq')]
    public function syncITReq($it)
    {

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();

        $detail = DB::table('Luv2_it_req_detail')->where('no', $it)->get();
        $itreq = DB::table('Luv2_it_req')->where('no', $it)->first();
        $lines = [];
            foreach ($detail as $item) {
                $lines[] = [
                    'BaseEntry' => $itreq->entry,
                    'BaseLine' => $item->linenum,
                    'ItemCode' => $item->item_code,
                    'Quantity' => $item->qty,
                    'WhsCode' => $itreq->whs_code,
                    'FromWhsCode' => $itreq->whs_code_from
                ];
            }
            $data = [
                'DocDate' => $itreq->date,
                'Filler' => $itreq->whs_code_from,
                'ToWhsCode' => $itreq->whs_code,
                'Comments' => $itreq->comments,
                'Lines' => $lines,
            ];

            try{
                $client = new Client();
                $response = $client->post($setting->url . '/api/addit',[
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    DB::table('Luv2_it_req')->where('no', $it)->update(['sync' => 'Y']);
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } catch (\Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }

            $this->isloading = false;
            $this->dispatch('refreshjs');

        // $data = [
        //     "CardCode" => $setting->cardcode,
        //     "CntctCode" => "0",
        //     "NumAtCard" => "0",
        //     "DocDate" => $formattedDate,
        //     "DocDueDate" => $formattedDate,
        //     "TaxDate" => $formattedDate,
        //     "SlpCode" => $idsales,
        //     "Comments" => $commentcode,
        //     "BPLId" => $setting->bpl_id,
        //     "CashAccount" => $cashAccount,
        //     "CashSum" => $cash,
        //     "TransferAccount" => $transferAccount,
        //     "TransferSum" => $card,
        //     "TransferDate" => $currentDate,
        //     "DocType" => "C",
        //     "Lines" => $lines,
        // ];
    }
}
