<?php

namespace App\Livewire\Forms;

use App\Models\Cart;
use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\ItemPriceListDisc;
use App\Models\ItemPriceListDiscQty;
use App\Models\Settings;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Livewire\Form;
use Illuminate\Support\Str;


class CartForm extends Form
{
    public string $itemname = '';
    public string $itemprice = '';
    public string $itemcode = '';
    public string $itemqty = '';
    public $discount = '';
    public $promo = 0;
    public $promotipe = 0;
    public $pack = 0;
    public $benefit = 'N';
    public string $nprice = '';
    // #[Rule('required', message: 'The Sales is required.')]
    public string $sales = '';

    public function store()
    {
        $qty = $this->itemqty;
        $price = $this->itemprice;
        $discount = $this->discount;
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $memberId = session('member'); // Retrieve the member ID from the session
        $sessionmember = session('discountmemb');
        $now = now();

        //dinonaktifkandulu
        // if ($sessionmember == 2 && !is_null($memberId)) { // 2 dan pakai member

        //     $price = $price - ($price * $setting->member_disc);
        // } elseif ($sessionmember == 1 && !is_null($memberId)) {
        //     $pricedisc = ItemPriceListDisc::where('item_code', $this->itemcode)
        //         ->where('cardcode', $memberId)
        //         ->whereDate('from_date', '<=', $now)
        //         ->whereDate('to_date', '>=', $now)
        //         ->first();

        //     if ($pricedisc) {
        //         $price = $pricedisc->disc_price;
        //         $this->itemprice = $price;
        //         $discount = 1;
        //     } else {
        //         $this->itemprice = $price;
        //         $discount = 0;
        //     }
        // } else {
        //     // No discount applies
        // }
        $getiditem = Item::where('code', $this->itemcode)->first();
        // if (session()->has('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id) && session('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id) === true) {
        //     $this->promo = 0;
        //     $this->promotipe = 0;
        //     $this->pack = 0;
        //     $this->benefit = 'N';
        // } else {
        //     // Do something else if the session variable is not true
        //     // For example:
        //     // Perform alternative actions
        //     // Set another flag
        // }
        if (Str::startsWith($this->itemcode, 'BUY') || Str::startsWith($this->itemcode, 'FG') || Str::startsWith($this->itemcode, 'VOUCHER')) {
            $totalprice = -$qty * $price;
            $cart = Cart::create([
                'code' => $this->itemcode,
                'barcode' => $getiditem->barcode,
                'name' => $this->itemname,
                'price' => $price,
                'nprice' => $this->nprice,
                'sandbox' => 'N',
                'discount' => $discount,
                'id_sales' => $this->sales,
                'id_user' => $user->id,
                'id_member' => $memberId,
                'qty' => -$this->itemqty,
                'total_price' => $totalprice,
                'promo' => $this->promo,
                'promo_tipe' => $this->promotipe,
                'pack' => $this->pack,
                'benefit' => $this->benefit,
                'grouping' => $this->promo,
            ]);
        } else {
            $totalprice = $qty * $price;
            $cart = Cart::create([
                'code' => $this->itemcode,
                'barcode' => $getiditem->barcode,
                'name' => $this->itemname,
                'price' => $price,
                'nprice' => $this->nprice,
                'sandbox' => 'N',
                'discount' => $discount,
                'id_sales' => $this->sales,
                'id_user' => $user->id,
                'id_member' => $memberId,
                'qty' => $this->itemqty,
                'total_price' => $totalprice,
                'promo' => $this->promo,
                'promo_tipe' => $this->promotipe,
                'pack' => $this->pack,
                'benefit' => $this->benefit,
                'grouping' => $this->promo,


            ]);
        }


        return $cart;
    }

    public function updateQty()
    {
        $existingCart = Cart::where('code', $this->itemcode)
            ->where('promo', $this->promo)
            ->where('id_user', auth()->user()->id)
            ->first();

        // if (session('discountmemb') == 1) { //dinonaktifkandulu
        //     $pricelist = $setting->member_pricelist;
        // } else {
        // }

        if ($existingCart) {
            $sessionmember = session('discountmemb');
            $memberId = $existingCart->member_id;
            $now = now();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $whs = Warehouse::where('code', $setting->wh_code)->first();
            $pricelist = $whs->id_pricelist;

            // if ($sessionmember == 1 && !is_null($memberId)) {
            //     $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
            //                     ->where('cardcode', $memberId)
            //                     ->orderBy('qty', 'asc')
            //                     ->get();

            //  } else {
            //     $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
            //                         ->where('cardcode', '*'.$pricelist)
            //                         ->orderBy('qty', 'asc')->get();
            // }
            if ($existingCart->promo !== 0) {
                $itemPriceDiscounts = DB::table('Luv2_promo_item_qty')
                    ->where('no', $existingCart->promo)
                    ->orderBy('qty', 'asc')
                    ->get();
            } else {
                if ($sessionmember == 1 && !is_null($memberId)) {
                    $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
                        ->where('cardcode', $memberId)
                        ->orderBy('qty', 'asc')
                        ->get();
                } else {
                    $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
                        ->where('cardcode', '*' . $pricelist)
                        ->orderBy('qty', 'asc')->get();
                }
            }
            if ($itemPriceDiscounts->isNotEmpty()) {
                $totalAddedQty = $this->itemqty;

                foreach ($itemPriceDiscounts as $itemPriceDiscount) {
                    $existingCartplus = $existingCart->qty + $totalAddedQty;
                    if ($existingCartplus >= $itemPriceDiscount->qty) {
                        $price = $itemPriceDiscount->disc_price;
                        $existingCart->update([
                            'price' => $price,
                            'qty' => $existingCartplus,
                            'total_price' => $price * $existingCartplus,
                        ]);
                    } else {
                        $existingCart->update([
                            'total_price' => $existingCart->price * ($existingCart->qty + $this->itemqty),
                            'qty' => $existingCart->qty + $totalAddedQty,
                        ]);
                    }
                    $totalAddedQty = 0; // Increment even if discount not applied

                }
            } else {
                $existingCart->update([
                    'total_price' => $existingCart->price * ($existingCart->qty + $this->itemqty),
                    'qty' => $existingCart->qty + $this->itemqty,
                ]);
            }
        }

        return $existingCart;
    }

    public function sameItemBundle()
    {
        $qty = $this->itemqty;
        $price = $this->itemprice;
        $discount = $this->discount;
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $memberId = session('member'); // Retrieve the member ID from the session
        $sessionmember = session('discountmemb');
        $now = now();

        //dinonaktifkandulu
        // if ($sessionmember == 2 && !is_null($memberId)) { // 2 dan pakai member

        //     $price = $price - ($price * $setting->member_disc);
        // } elseif ($sessionmember == 1 && !is_null($memberId)) {
        //     $pricedisc = ItemPriceListDisc::where('item_code', $this->itemcode)
        //         ->where('cardcode', $memberId)
        //         ->whereDate('from_date', '<=', $now)
        //         ->whereDate('to_date', '>=', $now)
        //         ->first();

        //     if ($pricedisc) {
        //         $price = $pricedisc->disc_price;
        //         $this->itemprice = $price;
        //         $discount = 1;
        //     } else {
        //         $this->itemprice = $price;
        //         $discount = 0;
        //     }
        // } else {
        //     // No discount applies
        // }
        $getiditem = Item::where('code', $this->itemcode)->first();

        $totalprice = $qty * $price;
        $cart = Cart::create([
            'code' => $this->itemcode,
            'barcode' => $getiditem->barcode,
            'name' => $this->itemname,
            'price' => $price,
            'nprice' => $this->nprice,
            'sandbox' => 'N',
            'discount' => $discount,
            'id_sales' => $this->sales,
            'id_user' => $user->id,
            'id_member' => $memberId,
            'qty' => $this->itemqty,
            'total_price' => $totalprice,
            'promo' => $this->promo,
            'promo_tipe' => $this->promotipe,
            'pack' => $this->pack,
            'benefit' => $this->benefit,
            'grouping' => $this->promo,

        ]);

        return $cart;
    }

    public function update()
    {
        $existingCart = Cart::where('code', $this->itemcode)
            ->where('promo', $this->promo)
            ->where('id_user', auth()->user()->id)
            ->first();

        $existingCart->update([
            'pack' => $this->pack,
        ]);
        return $existingCart;
    }
}
