<?php

namespace App\Livewire\Cashier;

use Livewire\Attributes\On;
use Livewire\Component;

class SelectDiscount extends Component
{
    public $dataDisc = [];
    public $button = '';
    public $title = '';
    public $selectedPromo;
    public $openmodalDisc = false;
    public $just1Disc = false;
    public function render()
    {
        return view('livewire.cashier.select-discount');
    }

    #[On('selectDiscount')]
    public function updatedDatadisc($dataDisc)
    {
        $dataDiscFilter = [];
        foreach ($dataDisc as $record) {
            $no = $record['no'];
            $pack = $record['pack'];
            if (!isset($dataDiscFilter[$no]) || $pack < $dataDiscFilter[$no]['pack']) {
                $dataDiscFilter[$no] = $record;
            }
        }

        $dataDiscFilter = array_values($dataDiscFilter); // Re-index the array if necessary
        $this->dataDisc = $dataDiscFilter;
        $this->button = 'save';
        $this->title = 'Select Discount';
        $this->selectedPromo = !empty($this->dataDisc) ? $this->dataDisc[0]['no'] : null;

        $this->dispatch('openModalSelect')->to(Transaction::class);
    }

    // public function updatedDatadisc($dataDisc)
    // {
    //     $dataDiscFilter = [];

    //     // Check if session data contains "promo-voucher-qty"
    //     if (session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
    //         foreach ($dataDisc as $record) {
    //             // Exclude records where tipe is 6 and benefit is 2
    //             if (!($record['tipe'] == 6 && $record['benefit'] == 1)) {
    //                 $no = $record['no'];
    //                 $pack = $record['pack'];
    //                 if (!isset($dataDiscFilter[$no]) || $pack < $dataDiscFilter[$no]['pack']) {
    //                     $dataDiscFilter[$no] = $record;
    //                 }
    //             }
    //         }
    //     }
        
    //     $dataDiscFilter = array_values($dataDiscFilter); 
    //     $this->dataDisc = $dataDiscFilter;
    //     $this->button = 'save';
    //     $this->title = 'Select Discount';
    //     $this->selectedPromo = !empty($this->dataDisc) ? $this->dataDisc[0]['no'] : null;

    //     $this->dispatch('openModalSelect')->to(Transaction::class);
    // }

    #[On('selectValue')]
    public function updatedDatadiscvalue($dataDisc)
    {
        $this->dataDisc = $dataDisc;
        if (count($dataDisc) === 1) {
            $this->just1Disc = true;
        }else{
            $this->just1Disc = false;
        }
        $this->button = 'saveValue';
        $this->title = 'Select Promo by Value';
        $this->selectedPromo = !empty($this->dataDisc) ? $this->dataDisc[0]['no'] : null;
        $this->dispatch('openModalSelect')->to(Transaction::class);
    }

    public function save()
    {
        $this->dispatch('closeModalDisc');
        $this->dispatch('closeModalDisctoTransaction')->to(Transaction::class);
        
        $selectedDiscountData = collect($this->dataDisc)->firstWhere('no', $this->selectedPromo);
        $this->dispatch('selectedDiscountData', $selectedDiscountData)->to(Transaction::class);
        $this->openmodalDisc = false;
        
       

    }

    public function saveValue()
    {
        $selectedValueData =  $this->selectedPromo;
        $this->dispatch('selectedValueData', $selectedValueData)->to(Transaction::class);
        $this->openmodalDisc = false;
        $this->dispatch('closeModalDisc');
        $this->dispatch('closeModalDisctoTransaction')->to(Transaction::class);

        if($this->just1Disc){
            $this->dispatch('checkCartValue');
        }

    }

    public function skipDisc()
    {
        $this->openmodalDisc = false;
        $this->dispatch('closeModalDisc');
        $this->dispatch('closeModalDisctoTransaction')->to(Transaction::class);
        $this->dispatch('openModalAfterSkipGWP')->to(Table::class);


    }

    // public function saveValueIf1Discount()
    // {
    //     $selectedValueData =  $this->selectedPromo;
    //     $this->dispatch('selectedValueData', $selectedValueData)->to(Transaction::class);
    //     $this->openmodalDisc = false;

    //     $this->dispatch('closeModalDisc');
    //     $this->dispatch('closeModalDisctoTransaction')->to(Transaction::class);
    //     $this->dispatch('checkCartValue')->to(Transaction::class);

    // }

    public function modalDiscOpen()
    {
        $this->openmodalDisc = true;

    }
    
    #[On('savetheDiscount')]
    public function saveDiscount()
    {
        if($this->button == 'saveValue'){
            $this->saveValue();
        }elseif($this->button == 'save'){
            $this->save();
        }
    }
}
