<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Settings;
use App\Models\Warehouse;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;

use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function validateLogin(Request $request)
    {
        $request->validate([
            $this->username() => 'required|string',
            'password' => 'required|string',
        ]);
    }

    protected function attemptLogin(Request $request)
    {
        $user = $this->guard()->getProvider()->retrieveByCredentials($this->credentials($request));

        if ($user && $user->active === 'N') {
            return false;
        }

        return $this->guard()->attempt(
            $this->credentials($request),
            $request->boolean('remember')
        );
    }

    protected function credentials(Request $request)
    {
        return $request->only($this->username(), 'password');
    }

    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();
       
        $this->clearLoginAttempts($request);

        if ($response = $this->authenticated($request, $this->guard()->user())) {
            return $response;
        }
        $user = Auth::user();
        $whs = Warehouse::where('code', $user->whs_code)->first();
        $setting = Settings::first();
        $id_company = $setting->id_company;
        if($setting->login == 'N'){
            $setting->update([
                'login' => 'Y',
                'wh_code' => $whs->code,
                'wh_name' => $whs->name,
                'address' => $whs->address,
                'phone' => $whs->phone,
                'email' => $whs->email,
                'receipt_footer' => $whs->footer,
                'cashacc'=> $whs->cashacc,
                'cardacc' => $whs->cardacc,
                'bpl_id' => $whs->bpl_id,
                'sbu' => $whs->sbu,
                'cardcode' => $whs->cardcode,
                'cost1' => $whs->cost1,
                'cost2' => $whs->cost2,
                'cost3' => $whs->cost3,
                'cost4' => $whs->cost4,
                'cost5' => $whs->cost5,
            ]);
        }
        if ($setting->member == 2) {
            Session::put('discountmemb', 2); 
        } elseif ($setting->member == 1) {
            Session::put('discountmemb', 1); 
        } else {
            Session::put('discountmemb', 0);
        }
        Session::put('id_company', $id_company); 

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect()->intended($this->redirectPath());
    }

    protected function sendFailedLoginResponse(Request $request)
    {
        $credentials = $this->credentials($request);
        $user = $this->guard()->getProvider()->retrieveByCredentials($credentials);

        if (!$user) {
            throw ValidationException::withMessages([
                $this->username() => [trans('Username is incorrect!')],
            ]);
        }
        if ($user->active === 'N') {
            throw ValidationException::withMessages([
                $this->username() => [trans('User is not active, please contact admin!')],
            ]);
        }
        if (!$this->guard()->validate($credentials)) {
            throw ValidationException::withMessages([
                'password' => [trans('Password is incorrect !')],
            ]);
        }

        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }

    public function logins(Request $request)
    {
        $this->validateLogin($request);
        $data = $request->all();
        if (
            method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)
        ) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
            if ($request->hasSession()) {
                $request->session()->put('auth.password_confirmed_at', time());
            }
            if (isset($data['remember']) && !empty($data['remember'])) {
                setcookie("name", $data['name'], time() + 3600);
                setcookie("password", $data['password'], time() + 3600);
            } else {
                setcookie("name", "");
                setcookie("password", "");
            }
            session(['theme' => 'dark']);

            return $this->sendLoginResponse($request);
        }


        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }
}
