<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Member;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Exception;
use Laravel\Socialite\Facades\Socialite;

class GoogleSocialiteController extends Controller
{
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleCallback()
    {
        try {
            $user = Socialite::driver('google')->user();

            $finduser = User::where('social_id', $user->id)->first();

            if ($finduser)  
            {
                Auth::login($finduser);

                $checkmember = Member::where('email', $finduser->email)->first();
                    if($checkmember)
                    {
                        $checkmember->delete();
                    }
                return redirect('/member/register');
            }
            else
            {
                $maxId = User::max('id');
                $newUser = User::create([
                    'id' => $maxId,
                    'name' => $user->name,
                    'email' => $user->email,
                    'social_id' => $user->id,
                    'social_type' => 'Google',
                    'password' => bcrypt('password'),  
                    'role' => 'Member',
                ]);

                Auth::login($newUser);

                return redirect('/member/register');
            }

        }
        catch (Exception $e)
        {
            dd($e->getMessage());
        }
    }
}