<?php

namespace App\Console\Commands;

use App\Exports\ExportReturn;
use App\Mail\MyTestMail;
use App\Models\Invoice;
use App\Models\Settings;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;

class SendDemoEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:send-demo-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send demo email with attachment';
    /**
     * Execute the console command.
     */
    public function handle()
    {
        $now = Carbon::now();
        $invoices = Invoice::whereNull('return_sale')->get();
        $filename = "Invoice Report - {$now}.xlsx";

        $excelFile = Excel::download(new ExportReturn($invoices), $filename)->getFile();

        $fileContents = file_get_contents($excelFile);
        $user = Auth::user();
        $setting = Settings::first();
        $emails = $setting->email_sandbox;

        Mail::to($emails)->send(new MyTestMail($fileContents, $filename));

        info('scheduled working!');
    }
}
