@extends('layouts.header')

@section('content')
    <style>
        .container {
            max-width: 1920px;
        }

        .container .row .card {
            width: 700px;
            margin: 30px;
            background: rgba(255, 255, 255, 0.1);
            overflow: hidden;
            backdrop-filter: blur(5px);
            border-top: 1px solid rgba(255, 255, 255, 0.5);
            border-left: 1px solid rgba(255, 255, 255, 0.5);
            border-radius: 15px;
        }

        .container .row .card .card-body {
            padding: 1rem 1.2rem;
        }

        .container .row .card .card-body .card-img img {
            width: 60px;
            height: 60px;
            object-fit: cover;
            transform: translateY(50px);
            transition: 0.5s;
            border-radius: 50%
        }

        .container .row .card .card-body .name {
            transform: translateY(50px);
            transition: 0.5s
        }

        html,
        body {
            height: 100%;
            margin: 0;
            /* Remove default margin */
            padding: 0;
            /* Remove default padding */
            font-family: 'Poppins', sans-serif;
        }

        .header-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }

        .header-bar .logo {
            flex-grow: 1;
            text-align: center;
        }

        .header-bar .back-button {
            margin-right: auto;
        }

        .back-button img {
            transition: transform 0.3s ease;
        }

        .back-button img:hover {
            transform: scale(1.2);
            /* Memperbesar gambar saat di-hover */
        }

        .back-button img:active {
            transform: scale(0.9);
            /* Mengecilkan gambar saat diklik */
        }
    </style>
    <div class="container bg-home">
        <div class="d-flex justify-content-between" style="margin-inline: 7rem">
            <div>
                <div class="logo-home margin-logo-login-register">
                    <img src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}" alt="Image Description">
                </div>
                <div class="">
                    {{-- <div class="simple-inv">
                    Simple Inventory
                </div> --}}
                    {{-- <div style="background-color: #098cdf; font-size: 13px; border-radius: 1rem; padding-inline: 11px; padding-block: 2px; color: #fff">
                    {{ env('VERSION') }}
                </div> --}}
                </div>
            </div>
        </div>
        <div class="container row justify-content-center align-items-center" style="min-height: 75vh">
            <div class="col-lg-4 d-flex justify-content-center align-items-center bg-login-register">
                <div class="login-card">
                    <div class="card-header">
                        <h1 class="card-title text-center fs-2 pt-2 fw-bolder">Register New Member</h1>
                    </div>
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if (session('danger'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('danger') }}
                        </div>
                    @endif
                    <div class="card-body mt-5">
                        <form method="POST" action="{{ route('member.store') }}">
                            @csrf
        
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <input id="name" type="text"
                                        class="rounded-pill form-control @error('name') is-invalid @enderror" name="name"
                                        value="{{ old('name') }}" required autocomplete="off" placeholder="Name"
                                        autofocus>
        
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
        
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <input id="email" type="email"
                                        class="rounded-pill form-control @error('email') is-invalid @enderror"
                                        name="email" value="{{ old('email') }}" placeholder="Email" required
                                        autocomplete="off">
        
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
        
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <input id="hp" type="hp"
                                        class="rounded-pill form-control @error('hp') is-invalid @enderror" name="phone"
                                        placeholder="Phone Number" value="{{ old('hp') }}" required>
        
                                    @error('hp')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
        
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <input id="alamat" type="address"
                                        class="rounded-pill form-control @error('address') is-invalid @enderror"
                                        name="address" placeholder="Address" value="{{ old('address') }}" required
                                        autocomplete="off">
        
                                    @error('address')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
        
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <input id="hobby" type="hobby"
                                        class="rounded-pill form-control @error('hobby') is-invalid @enderror"
                                        name="hobby" placeholder="Hobby" value="{{ old('hobby') }}" required
                                        autocomplete="off">
        
                                    @error('hobby')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
        
                            <div class="row text-center">
                                <div class="card-header">
        
                                    <button class="custom-button1 rounded-pill mt-3">
                                        <a href="{{ route('member.index') }}" style="color: #fff; text-decoration: none">
                                            Back
                                        </a>
                                    </button>
        
                                    <button type="submit" class="custom-button1 rounded-pill mt-3">
                                        {{ __('Save') }}
                                    </button>
        
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        {{-- <div class="row justify-content-center">
        <div class="card" style="background-color: rgb(47, 73, 88); color: white">
            <div class="card-header fs-4 text-center">{{ __('Register With Social') }}</div>
            <div class="row">
                <div class="col-md-6">
                    <div class="card-body text-center">
                        <h1>Google</h1>
                        <img src="{{ asset('assets/generategoogle.svg') }}"  class="mx-auto">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card-body text-center">
                        <h1>Twitter</h1>
                        <img src="{{ asset('assets/googleqrcode.png') }}" alt="" width="65%" class="mx-auto">
                    </div>
                </div>
            </div>
        </div>

    </div> --}}


    </div>
@endsection
