<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="">

<head>
    <script>
        (function() {
            const storedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const theme = storedTheme || (prefersDark ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', theme);
        })();
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-192x192.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-512x512.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/apple-touch-icon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-16x16.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-32x32.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon.ico') }}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>POS - Softcomp.io</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.css" />

</head>

<style>
    .login-here {
        text-transform: initial;
        border-radius: .5rem;
        padding-inline: 10px;
        font-size: 15px;
        margin-top: -6px;
    }

    .login-here:hover {
        background-color: #4a4cd610;
        color: rgb(39, 38, 38);
    }

    .logo-home img {
        max-width: 160px;
        height: auto;
    }

    .arrow {
        color: white;
    }

    .animate-hover:hover {
        transform: scale(1.05);
        transition: transform 0.3s;
    }

    *,
    *:before,
    *:after {
        box-sizing: border-box;
    }

    .wrapper {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    a {
        display: block;
        text-decoration: none;
        text-align: center;
        border-radius: 50px;
        color: seagreen;
        font-size: 20px;
        font-family: arial;
        position: relative;
        overflow: hidden;
        background: transparent;
        text-transform: uppercase;
        transition: all .35s;
    }

    a:before,
    a:after {
        position: absolute;
        content: "";
        width: 100%;
        height: 100%;
        top: -100%;
        left: 0;
        background: #13202b13;
        z-index: -1;
        transition: all .35s;
    }

    a:before {
        opacity: .5;
    }

    a:after {
        transition-delay: .2s;
    }

    a:hover {
        color: #fff;
    }

    a:hover:before,
    a:hover:after {
        top: 0;
    }

    .typing {
        overflow: hidden;
        /* Ensures the text is clipped at the start of the animation */
        border-right: .15em solid orange;
        /* The typewriter cursor */
        white-space: nowrap;
        /* Keeps the content on a single line */
        margin: 0 auto;
        /* Centers the text */
        letter-spacing: .15em;
        /* Adjust as needed */
        animation:
            typing 2s steps(40, end),
            /* Increased steps for smoother animation */
            blink-caret .7s step-end infinite;
        /* Blinking cursor effect */
    }

    /* The typing effect */
    @keyframes typing {
        from {
            width: 0
        }

        to {
            width: 100%
        }

        /* Changed to 100% to type out the full text */
    }

    /* The typewriter cursor effect */
    @keyframes blink-caret {

        from,
        to {
            border-color: transparent
        }

        50% {
            border-color: orange;
        }
    }

    .arrow-icon {
        animation: bounce 2s infinite;
    }

    @keyframes bounce {

        0%,
        20%,
        50%,
        80%,
        100% {
            transform: translateY(0);
        }

        40% {
            transform: translateY(-10px);
        }

        60% {
            transform: translateY(-5px);
        }
    }

    .hover-zoom img {
        transition: transform 0.3s ease;
    }

    .hover-zoom:hover img {
        transform: scale(1.5);
        /* Memperbesar gambar sebesar 20% */
    }
</style>

<body class="">
    <div class="bg-center bg-home">
        <div class="bg-center">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center pt-4">
                    <div class="logo-home">
                        <img src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}" alt="Image Description">
                    </div>
                    <div class="d-flex justify-content-end align-items-center">
                        @auth
                            <div class="home-text1 d-flex align-items-center gap-2">
                                <div class="">
                                    <img src="{{ asset('assets/user.png') }}" width="22px" height="auto"
                                        alt="Image Description">
                                </div>
                                {{ ucwords(explode('@', auth()->user()->username)[0]) }}

                            </div>
                        @else
                            <div class="d-flex gap-2" style="justify-content: center; align-items: center">
                                <a href="{{ route('login') }}" class="login-here">Log in here</a>

                            </div>
                            @endif
                            <div class="sidebar-icon">
                                <a class="nav-link {{ request()->routeIs('logouts') ? 'active' : '' }}"
                                    href="{{ route('logouts') }}"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M8.25 9V5.25A2.25 2.25 0 0 1 10.5 3h6a2.25 2.25 0 0 1 2.25 2.25v13.5A2.25 2.25 0 0 1 16.5 21h-6a2.25 2.25 0 0 1-2.25-2.25V15m-3 0-3-3m0 0 3-3m-3 3H15" />
                                    </svg>

                                </a>
                            </div>

                            <form id="logout-form" action="{{ route('logouts') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </div>
                    </div>

                    @kasir 
                        <div class="d-flex justify-content-center align-items-center gap-2 margin-pos-kasir">
                            <div>
                                <div class="custom-font" style="color: #14b8a6">
                                    Point of Sales <span class="span-pos">System</span>
                                </div>
                            </div>
                        </div>

                        <div id="tutorialModal" tabindex="-1" aria-labelledby="tutorialModalLabel" aria-hidden="true"
                            style="display: flex; flex-direction: column; justify-content: center; align-items: center; height: 45vh;text-align: center;">
                            <div class="grid-item-kasir">
                                <div class="d-flex justify-content-center gap-5">
                                    <div class="col pos-cashier">
                                        <a href="{{ route('welcome.dashboard') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/cash-machine (1).png') }}"
                                                        class="home-icon-kasir" alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Sale</h2>
                                    </div>
                                    <div class="col item">
                                        <a href="{{ route('item') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/product (3).png') }}" class="home-icon-kasir"
                                                        alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Find Items</h2>
                                    </div>
                                    <div class="col returnSale">
                                        <a href="{{ route('welcome.returnsale') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/return.png') }}" class="home-icon-kasir"
                                                        alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Exchange Items</h2>
                                    </div>
                                    <div class="col member">
                                        <a href="{{ route('member.index') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/team (1).png') }}"
                                                        class="home-icon-kasir" alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Members</h2>
                                    </div>    
                                    <div class="col laporanPenjualan">
                                        <a href="{{ route('report.reportinvoicereturnsale') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/cash-machine (1).png') }}" class="home-icon-kasir"
                                                        alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Sales</br> Report</h2>
                                    </div>
                                    <div class="col laporanTransaksiMember">
                                        <a href="{{ route('report.reporttransactionmember') }}" style="border-radius: 1rem"
                                            class="d-flex align-items-center justify-content-center custom-bg-kasir text-decoration-none animate-hover shadow-sm">
                                            <div>
                                                <div class="bg-card-welcome">
                                                    <img src="{{ asset('assets/money-transfer.png') }}"
                                                        class="home-icon-kasir" alt="Image Description">
                                                </div>
                                            </div>
                                        </a>
                                        <h2 class="home-text">Member </br>Transaction Reports</h2>
                                    </div>    
                                </div>
                            </div>
                        </div>
                    @endkasir
                    @admin
                        <div class="d-flex justify-content-center align-items-center gap-2 margin-pos-admin">
                            <div>
                                <div class="custom-font" style="color: #14b8a6">
                                    Point of Sales <span class="span-pos">System</span>
                                </div>
                            </div>
                        </div>

                        <div id="tutorialModal" tabindex="-1" aria-labelledby="tutorialModalLabel" aria-hidden="true"
                            style="display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center;">
                            <div style="padding-inline: 5rem; margin-bottom: 3rem">
                                <div class="container d-flex gap-3" style="flex-direction: column">
                                    <div class="">
                                        <div class="d-flex gap-2 align-items-center justify-content-left">
                                            <h6
                                                style="font-weight: 600; text-align: center; margin-top: 7px; margin-left: 1rem">
                                                Sale</h6>
                                        </div>
                                        <div class="grid-item2">
                                            <div class="row g-3 d-flex justify-content-center">
                                                <div class="col col-lg-1 col-md-1 pos-cashier">
                                                    <a href="{{ route('welcome.dashboard') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/cash-machine (1).png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Sale</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1 item">
                                                    <a href="{{ route('item') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/product (3).png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Items</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1 returnSale">
                                                    <a href="{{ route('welcome.returnsale') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/return.png') }}" class="home-icon"
                                                                    alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Exchange </br> Items</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1 member">
                                                    <a href="{{ route('member.index') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/team (1).png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Members</h2>
                                                </div>           
                                            </div>
                                        </div>
                                    </div>

                                    <div class="master">
                                        <div class="d-flex gap-2 align-items-center justify-content-left">
                                            <h6
                                                style="font-weight: 600; text-align: center; margin-top: 7px; margin-left: 1rem;">
                                                Product</h6>
                                        </div>
                                        <div class="grid-item2">
                                            <div class="row g-3 d-flex justify-content-center">
                                                <div class="col col-lg-1 col-md-1 produk">
                                                    <a href="{{ route('item.input') }}"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Item')"
                                                        style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/add-product.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Product</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Pricelist')"
                                                        style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/price-list.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Price list</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Brand')"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/brand.png') }}" class="home-icon"
                                                                    alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Brand</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Category')"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/category.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Category</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Size')"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/size.png') }}" class="home-icon"
                                                                    alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Size</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Unit')"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/unit.png') }}" class="home-icon"
                                                                    alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Unit of Measure</h2>
                                                </div>

                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('promo.index') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/promo.png') }}" class="home-icon"
                                                                    alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Promo</h2>
                                                </div>

                                                <div class="col col-lg-1 col-md-1 transaksi" data-bs-toggle="collapse"
                                                    href="#multiCollapseExample2" role="button" aria-expanded="false"
                                                    aria-controls="multiCollapseExample2">
                                                    <div style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/transaction-history.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h2 class="home-text">Transaction</h2>
                                                </div>
                                            </div>

                                            <div class="multi">
                                                <div class="row">
                                                    <div class="col">
                                                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                                                            {{-- <hr /> --}}
                                                            <div class="card-body">
                                                                <div class="d-flex gap-3 justify-content-center">
                                                                    <div class="col col-md-2 col-lg-1 goodReceipts">
                                                                        <a href="{{ route('po.index') }}"
                                                                            style="border-radius: 1rem"
                                                                            @auth @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('welcome.dashboard') }}')" @endif @endauth
                                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                            <div>
                                                                                <div class="bg-card-welcome">
                                                                                    <img src="{{ asset('assets/download.png') }}"
                                                                                        class="home-icon"
                                                                                        alt="Image Description">
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <h2 class="home-text">Reception</h2>
                                                                    </div>
                                                                    <div class="col col-md-2 col-lg-1 goodReturn">
                                                                        <a href="{{ route('pr.index') }}"
                                                                            style="border-radius: 1rem"
                                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                            <div>
                                                                                <div class="bg-card-welcome">
                                                                                    <img src="{{ asset('assets/goods-return.png') }}"
                                                                                        class="home-icon"
                                                                                        alt="Image Description">
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <h2 class="home-text">Returns</h2>
                                                                    </div>
                                                                    <div class="col col-md-2 col-lg-1 itemTransfer">
                                                                        <a href="{{ route('item-transfer.index') }}"
                                                                            style="border-radius: 1rem"
                                                                            @auth
@if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('item-transfer.index') }}')" @endif @endauth
                                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                            <div>
                                                                                <div class="bg-card-welcome">
                                                                                    <img src="{{ asset('assets/purchase.png') }}"
                                                                                        class="home-icon"
                                                                                        alt="Image Description">
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <h2 class="home-text">Transfer of Goods</h2>
                                                                    </div>
                                                                    <div class="col col-md-2 col-lg-1 opname">
                                                                        <a href="{{ route('opname') }}"
                                                                            style="border-radius: 1rem"
                                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                            <div>
                                                                                <div class="bg-card-welcome">
                                                                                    <img src="{{ asset('assets/packages.png') }}"
                                                                                        class="home-icon"
                                                                                        alt="Image Description">
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                        <h2 class="home-text">Opname</h2>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="report">
                                        <div class="d-flex gap-2 align-items-center justify-content-left">
                                            <h6 style="font-weight: 600; text-align: center; margin-top: 7px; margin-left: 1rem">
                                                Report
                                            </h6>
                                        </div>
                                        <div class="grid-item2">
                                            <div class="row g-3 d-flex justify-content-center">
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reporttransactionmember') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/money-transfer.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Member Transactions</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1 report">
                                                    <a href="{{ route('report.reportinvoicereturnsale') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/seo-report.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Invoice</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.voucher') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/voucher.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Voucher</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reportgoodsreceipt') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/paper.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Goods Receipt</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reportgoodsreturn') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/receive.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Goods Return</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reportopname') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/report (1).png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Stock Opname</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reporttransfer') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/documents.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Item Transfer</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reportstock') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/asset.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Stock</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('report.reportstockcard') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/stock-market.png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Stock Card</h2>
                                                </div>
                                                <div class="col col-lg-1 col-md-1 activityLog">
                                                    <a href="{{ route('activity-log') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/log (1).png') }}" class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Activity Log</h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    

                                    <div class="">
                                        <div class="d-flex gap-2 align-items-center justify-content-left">
                                            <h6 style="font-weight: 600; text-align: center; margin-top: 7px; margin-left: 1rem">
                                                Settings
                                            </h6>
                                        </div>
                                        <div class="grid-item2">
                                            <div class="row g-3 d-flex justify-content-center">
                                                <div class="col col-lg-1 col-md-1">
                                                    <a href="{{ route('item.input') }}"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Supplier')"
                                                        style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div class="">
                                                            <div class="bg-card-welcome-2">
                                                                <div class="bg-card-welcome">
                                                                    <img src="{{ asset('assets/supplierr.png') }}"
                                                                        class="home-icon" alt="Image Description">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Supplier</h2>
                                                </div>
                                                @auth
                                                    <div class="col col-lg-1 col-md-1">
                                                        <a href="{{ auth()->user()->role == 'Admin' ? route('warehouse.index') : '#' }}"
                                                            style="border-radius: 1rem; {{ auth()->user()->role != 'Admin' ? 'pointer-events: none; opacity: 0.3;' : '' }}"
                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                            <div>
                                                                <div class="bg-card-welcome">
                                                                    <img src="{{ asset('assets/warehouse (1).png') }}"
                                                                        class="home-icon" alt="Warehouse Image">
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <h2 class="home-text">Store</h2>
                                                    </div>
                                                @endauth
                                    
                                                @guest
                                                    <div class="col col-lg-1 col-md-1">
                                                        <a href="{{ route('warehouse.index') }}" style="border-radius: 1rem"
                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                            <div>
                                                                <div class="bg-card-welcome">
                                                                    <img src="{{ asset('assets/warehouse (1).png') }}"
                                                                        class="home-icon" alt="Image Description">
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <h2 class="home-text">Store</h2>
                                                    </div>
                                                @endguest
                                    
                                                @auth
                                                    <div class="col col-lg-1 col-md-1">
                                                        <a href="{{ auth()->user()->role === 'Admin' ? route('user.index') : '#' }}"
                                                            style="border-radius: 1rem; {{ auth()->user()->role !== 'Admin' ? 'pointer-events: none; opacity: 0.3;' : '' }}"
                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                            <div>
                                                                <div class="bg-card-welcome">
                                                                    <img src="{{ asset('assets/human.png') }}" class="home-icon"
                                                                        alt="User Management">
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <h2 class="home-text">User Manage</h2>
                                                    </div>
                                                @endauth
                                                @guest
                                                    <div class="col col-lg-1 col-md-1">
                                                        <a href="{{ route('user.index') }}" style="border-radius: 1rem"
                                                            class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                            <div>
                                                                <div class="bg-card-welcome">
                                                                    <img src="{{ asset('assets/human.png') }}" class="home-icon"
                                                                        alt="Image Description">
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <h2 class="home-text">User Manage</h2>
                                                    </div>
                                                @endguest
                                    
                                                <div class="col col-lg-1 col-md-1 salesEmp">
                                                    <a href="{{ route('salesemp') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/assistant.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Store Staff</h2>
                                                </div>
                                    
                                                <div class="col col-lg-1 col-md-1 setting">
                                                    <a href="{{ route('settings') }}" style="border-radius: 1rem"
                                                        class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                        <div>
                                                            <div class="bg-card-welcome">
                                                                <img src="{{ asset('assets/forgot-password.png') }}"
                                                                    class="home-icon" alt="Image Description">
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <h2 class="home-text">Change Password</h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>

                            <div class="mt-4 container">
                                <div class="row d-flex justify-content-center">

                                </div>
                            </div>
                        </div>
                    @endadmin
{{-- belum --}}
                    @gudang
                        <div class="d-flex justify-content-center align-items-center gap-2 margin-pos">
                            <div>
                                <div class="custom-font" style="color: #14b8a6">
                                    Point of Sales <span class="span-pos">System</span>
                                </div>
                            </div>
                        </div>
                        <div id="tutorialModal" tabindex="-1" aria-labelledby="tutorialModalLabel" aria-hidden="true"
                            style="display: flex; flex-direction: column; justify-content: center; align-items: center; height: 63vh;text-align: center;">

                            <div class="master" style="margin-bottom: 2rem">
                                <div class="d-flex gap-2 align-items-center justify-content-start" style="margin-left: 1rem">
                                    <h6 style="font-weight: 600; text-align: center;">Product</h6>
                                </div>
                                <div class="grid-item2">
                                    <div class="row d-flex justify-content-center">
                                        <div class="col produk">
                                            <a href="{{ route('item.input') }}"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Item')"
                                                style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/add-product.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Product</h2>
                                        </div>
                                        <div class="col">
                                            <a href="{{ route('item.input') }}"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Pricelist')"
                                                style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/price-list.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Price List</h2>
                                        </div>
                                        <div class="col">
                                            <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Brand')"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/brand.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Brand</h2>
                                        </div>
                                        <div class="col">
                                            <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Category')"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/category.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Category</h2>
                                        </div>
                                        <div class="col">
                                            <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Size')"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/size.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Size</h2>
                                        </div>
                                        <div class="col">
                                            <a href="{{ route('item.input') }}" style="border-radius: 1rem"
                                                onclick="navigate(event, '{{ route('item.input') }}', 'Unit')"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/unit.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Unit</h2>
                                        </div>
                            
                                        <div class="col promo">
                                            <a href="{{ route('promo.index') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/promo.png') }}" class="home-icon"
                                                            alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Promotion</h2>
                                        </div>
                            
                                        <div class="col transaksi" data-bs-toggle="collapse" href="#multiCollapseExample2"
                                            role="button" aria-expanded="false" aria-controls="multiCollapseExample2">
                                            <div style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/transaction-history.png') }}"
                                                            class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </div>
                                            <h2 class="home-text">Transaction</h2>
                                        </div>
                                    </div>
                            
                                    <div class="multi">
                                        <div class="row">
                                            <div class="col">
                                                <div class="collapse multi-collapse" id="multiCollapseExample2">
                                                    <div class="card-body">
                                                        <div class="d-flex gap-3 justify-content-center">
                                                            <div class="col col-md-2 col-lg-2">
                                                                <a href="{{ route('po.index') }}"
                                                                    style="border-radius: 1rem"
                                                                    @auth @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('welcome.dashboard') }}')" @endif @endauth
                                                                    class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                    <div>
                                                                        <div class="bg-card-welcome">
                                                                            <img src="{{ asset('assets/download.png') }}"
                                                                                class="home-icon" alt="Image Description">
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <h2 class="home-text">Receiving</h2>
                                                            </div>
                                                            <div class="col col-md-2 col-lg-2">
                                                                <a href="{{ route('pr.index') }}"
                                                                    style="border-radius: 1rem"
                                                                    class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                    <div>
                                                                        <div class="bg-card-welcome">
                                                                            <img src="{{ asset('assets/goods-return.png') }}"
                                                                                class="home-icon" alt="Image Description">
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <h2 class="home-text">Returns</h2>
                                                            </div>
                                                            <div class="col col-md-2 col-lg-2">
                                                                <a href="{{ route('item-transfer.index') }}"
                                                                    style="border-radius: 1rem"
                                                                    @auth
                                                                    @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('item-transfer.index') }}')" @endif @endauth
                                                                    class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                    <div>
                                                                        <div class="bg-card-welcome">
                                                                            <img src="{{ asset('assets/purchase.png') }}"
                                                                                class="home-icon" alt="Image Description">
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <h2 class="home-text">Item Transfer</h2>
                                                            </div>
                                                            <div class="col col-md-2 col-lg-2">
                                                                <a href="{{ route('opname') }}" style="border-radius: 1rem"
                                                                    class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                                    <div>
                                                                        <div class="bg-card-welcome">
                                                                            <img src="{{ asset('assets/packages.png') }}"
                                                                                class="home-icon" alt="Image Description">
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                                <h2 class="home-text">Stock Opname</h2>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            
                                </div>
                            </div>
                            

                            <div>
                                <div class="d-flex gap-2 align-items-center justify-content-left" style="margin-left: 1rem">
                                    <h6 style="font-weight: 600; text-align: center; margin-top: 7px">Report</h6>
                                </div>
                                <div class="grid-item2">
                                    <div class="row g-3 d-flex justify-content-center">
                                        <div class="col member">
                                            <a href="{{ route('member.index') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/team (1).png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Member</h2>
                                        </div>
                                        <div class="col transaksiMember">
                                            <a href="{{ route('report.reporttransactionmember') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/money-transfer.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Member Transaction</h2>
                                        </div>
                                        <div class="col faktur">
                                            <a href="{{ route('report.reportinvoicereturnsale') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/seo-report.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Invoice</h2>
                                        </div>
                                        <div class="col voucher">
                                            <a href="{{ route('report.voucher') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/voucher.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Voucher</h2>
                                        </div>
                                        <div class="col goodReceipts">
                                            <a href="{{ route('report.reportgoodsreceipt') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/paper.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Goods Receipt</h2>
                                        </div>
                                        <div class="col goodReturn">
                                            <a href="{{ route('report.reportgoodsreturn') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/receive.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Goods Return</h2>
                                        </div>
                                        <div class="col opname">
                                            <a href="{{ route('report.reportopname') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/report (1).png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Stock Opname</h2>
                                        </div>
                                        <div class="col transferBarang">
                                            <a href="{{ route('report.reporttransfer') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/documents.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Item Transfer</h2>
                                        </div>
                                        <div class="col stok">
                                            <a href="{{ route('report.reportstock') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/asset.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Stock</h2>
                                        </div>
                                        <div class="col kartuStok">
                                            <a href="{{ route('report.reportstockcard') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/stock-market.png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Stock Card</h2>
                                        </div>
                                        <div class="col activityLog">
                                            <a href="{{ route('activity-log') }}" style="border-radius: 1rem"
                                                class="d-flex align-items-center justify-content-center custom-bg text-decoration-none animate-hover shadow-sm">
                                                <div>
                                                    <div class="bg-card-welcome">
                                                        <img src="{{ asset('assets/log (1).png') }}" class="home-icon" alt="Image Description">
                                                    </div>
                                                </div>
                                            </a>
                                            <h2 class="home-text">Activity Log</h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            

                            <div class="mt-4 container">
                                <div class="row d-flex justify-content-center">

                                </div>
                            </div>
                        </div>
                    @endgudang
                </div>
            </div>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

            <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
                integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous">
            </script>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"
                integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous">
            </script>
            <script src="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.js.iife.js"></script>

            <script>
                function navigateToSelectItem(event, url) {
                    event.preventDefault();

                    $.ajax({
                        url: '/set-session-to-url',
                        method: 'POST',
                        data: {
                            toUrl: url,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                window.location.href = "{{ route('select-warehouse') }}";
                            } else {
                                console.error('Failed to set session value.');
                            }
                        },
                        error: function(xhr) {
                            console.error('AJAX request failed.');
                        }
                    });
                }

                function navigate(event, url, item) {
                    event.preventDefault();
                    $.ajax({
                        url: '/set-session',
                        method: 'POST',
                        data: {
                            item: item,
                            _token: $('meta[name="csrf-token"]').attr('content') // Add CSRF token for Laravel
                        },
                        success: function(response) {
                            if (response.success) {
                                window.location.href = url;
                            } else {
                                console.error('Failed to set session value.');
                            }
                        },
                        error: function(xhr) {
                            console.error('AJAX request failed.');
                        }
                    });
                }
                document.addEventListener("DOMContentLoaded", function() {
                    const currentTheme = localStorage.getItem('theme') || 'light';

                    document.documentElement.setAttribute('data-bs-theme', currentTheme);

                    // Set the icon based on the theme
                    const themeIcon = document.getElementById('themeIcon');
                    if (currentTheme === 'dark') {
                        themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
                    } else {
                        themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
                    }
                });
                document.addEventListener('DOMContentLoaded', function() {
                    const themeButton = document.getElementById('toggleThemeButton');
                    const themeIcon = document.getElementById('themeIcon');

                    // Set initial theme
                    if (document.documentElement.getAttribute('data-bs-theme') === 'light') {
                        themeIcon.classList.add('bi-moon-fill');
                    } else {
                        themeIcon.classList.add('bi-sun-fill');
                    }

                    themeButton.addEventListener('click', function() {
                        const currentTheme = document.documentElement.getAttribute('data-bs-theme');
                        const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                        document.documentElement.setAttribute('data-bs-theme', newTheme);

                        // Change icon based on the new theme
                        if (newTheme === 'dark') {
                            themeIcon.classList.remove('bi-moon-fill');
                            themeIcon.classList.add('bi-sun-fill');
                        } else {
                            themeIcon.classList.remove('bi-sun-fill');
                            themeIcon.classList.add('bi-moon-fill');
                        }

                        // Save the selected theme in a cookie
                        document.cookie = `theme=${newTheme}; path=/; max-age=31536000`;
                    });
                });

                const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]')
                const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl))
                @admin
                const startWebsiteTour = () => {
                    const driver = window.driver.js.driver;
                    const driverObj = driver({
                        showProgress: true,
                        steps: [
                            {
                                element: '.pos-cashier',
                                popover: {
                                    title: 'Sales',
                                    description: 'Welcome! This is the Sales menu used to manage your sales transactions in real-time.'
                                }
                            },
                            {
                                element: '.member',
                                popover: {
                                    title: 'Member',
                                    description: 'The Member menu allows you to add new members and view their detailed information.'
                                }
                            },
                            {
                                element: '.item',
                                popover: {
                                    title: 'Item',
                                    description: 'The Item menu is used to add and manage products for sale. You can update product information and manage stock here.'
                                }
                            },
                            {
                                element: '.produk',
                                popover: {
                                    title: 'Product',
                                    description: 'Welcome to the Product menu. Here, you can manage product details, including adding, editing, or deleting items.'
                                }
                            },
                            {
                                element: '.transaksi',
                                popover: {
                                    title: 'Transaction',
                                    description: 'The Transaction menu is used to record and manage sales processes in real-time within the POS system.'
                                }
                            },
                            {
                                element: '.report',
                                popover: {
                                    title: 'Report',
                                    description: 'The Report menu provides summaries of essential data, from member transactions to activity logs, with visual descriptions to ease operational analysis.'
                                }
                            },
                            {
                                element: '.activityLog',
                                popover: {
                                    title: 'Activity Log',
                                    description: 'In the Activity Log, you can view the history of actions performed by users within the POS system.'
                                }
                            },
                            {
                                element: '.salesEmp',
                                popover: {
                                    title: 'Sales Staff',
                                    description: 'The Sales Staff menu is used to manage data for employees working as cashiers or sales personnel.'
                                }
                            },
                            // {
                            //     element: '.return',
                            //     popover: {
                            //         title: 'Return',
                            //         description: 'The Return menu is used to record and manage customer returns, either for refunds or exchanges.'
                            //     }
                            // },
                            {
                                element: '.setting',
                                popover: {
                                    title: 'Settings',
                                    description: 'In the Settings menu, you can configure various system preferences and settings for the POS to suit your business needs.'
                                },
                                onDeselected: () => {
                                    $.ajax({
                                        type: "POST",
                                        url: '/update-status-driver',
                                        data: {
                                            menu: "Home",
                                            _token: '{{ csrf_token() }}'
                                        },
                                        success: function(data) {},
                                        error: function(data, textStatus, errorThrown) {},
                                    });
                                }
                            },
                        ]

                    });

                    driverObj.drive();
                }
                @endadmin
                
                @kasir
                    // kasir disini startwebsitetour
                    const startWebsiteTour = () => {
                        const driver = window.driver.js.driver;
                        const driverObj = driver({
                            showProgress: true,
                            steps: [
                                {
                                    element: '.pos-cashier',
                                    popover: {
                                        title: 'Sales',
                                        description: 'Welcome to the POS Cashier Dashboard. Here, you can manage sales transactions in real-time.'
                                    }
                                },
                                {
                                    element: '.item',
                                    popover: {
                                        title: 'Item',
                                        description: 'The Item menu is used to add and manage products for sale. You can update product information and manage stock here.'
                                    }
                                },
                                {
                                    element: '.returnSale',
                                    popover: {
                                        title: 'Return Sale',
                                        description: 'This menu is used to record and manage returns from customers, either for refunds or item exchanges.'
                                    }
                                },
                                {
                                    element: '.member',
                                    popover: {
                                        title: 'Member',
                                        description: 'The Member menu allows you to add new members and view their detailed information.'
                                    }
                                },
                                {
                                    element: '.laporanPenjualan',
                                    popover: {
                                        title: 'Sales Report',
                                        description: 'This menu is used to access reports related to sales performance and transaction summaries.'
                                    }
                                },
                                {
                                    element: '.laporanTransaksiMember',
                                    popover: {
                                        title: 'Member Transaction Report',
                                        description: 'This menu allows you to view detailed reports of member transactions and analyze customer purchasing behavior.'
                                    },
                                    onDeselected: () => {
                                        $.ajax({
                                            type: "POST",
                                            url: '/update-status-driver',
                                            data: {
                                                menu: "Home",
                                                _token: '{{ csrf_token() }}'
                                            },
                                            success: function(data) {},
                                            error: function(data, textStatus, errorThrown) {},
                                        });
                                    }
                                },
                                // {
                                //     element: '.goodReceipts',
                                //     popover: {
                                //         title: 'Good Receipts',
                                //         description: 'Good Receipts are used to record the receipt of goods from suppliers, ensuring all received items match the order.'
                                //     }
                                // },
                                // {
                                //     element: '.goodReturn',
                                //     popover: {
                                //         title: 'Good Return',
                                //         description: 'The Good Return menu allows you to manage the return of goods to suppliers in case of damage or discrepancies.'
                                //     }
                                // },
                            ];
                        });

                        driverObj.drive();
                    }
                @endkasir

                @gudang
                    const startWebsiteTour = () => {
                        const driver = window.driver.js.driver;
                        const driverObj = driver({
                            showProgress: true,
                            steps: [
                                {
                                    element: '.produk',
                                    popover: {
                                        title: 'Product',
                                        description: 'Welcome to the Product menu. Here, you can manage product information, including adding, editing, or deleting items for sale.'
                                    }
                                },
                                {
                                    element: '.daftarHarga',
                                    popover: {
                                        title: 'Price List',
                                        description: 'Displays and manages the prices of available products.'
                                    }
                                },
                                {
                                    element: '.merek',
                                    popover: {
                                        title: 'Brand',
                                        description: 'Manage brand information of the products being sold.'
                                    }
                                },
                                {
                                    element: '.kategori',
                                    popover: {
                                        title: 'Category',
                                        description: 'Organize products by category to make searching easier.'
                                    }
                                },
                                {
                                    element: '.ukuran',
                                    popover: {
                                        title: 'Size',
                                        description: 'Manage product sizes, such as clothing sizes or item dimensions.'
                                    }
                                },
                                {
                                    element: '.satuanUkur',
                                    popover: {
                                        title: 'Unit of Measure',
                                        description: 'Define the units used to measure products.'
                                    }
                                },
                                {
                                    element: '.promo',
                                    popover: {
                                        title: 'Promotion',
                                        description: 'The Promotion menu is used to add and manage active promotions to boost sales.'
                                    }
                                },
                                {
                                    element: '.transaksi',
                                    popover: {
                                        title: 'Transaction',
                                        description: 'The Transaction menu is used to record and manage sales processes in real-time within the POS system.'
                                    }
                                },
                                {
                                    element: '.member',
                                    popover: {
                                        title: 'Member',
                                        description: 'In the Member menu, you can add new members and manage their data in detail.'
                                    }
                                },
                                {
                                    element: '.transaksiMember',
                                    popover: {
                                        title: 'Member Transaction',
                                        description: 'Manage transactions specifically made by registered members.'
                                    }
                                },
                                {
                                    element: '.faktur',
                                    popover: {
                                        title: 'Invoice',
                                        description: 'The Invoice menu allows you to manage documents related to completed transactions.'
                                    }
                                },
                                {
                                    element: '.voucher',
                                    popover: {
                                        title: 'Voucher',
                                        description: 'Manage and issue discount or gift vouchers.'
                                    }
                                },
                                {
                                    element: '.goodReceipts',
                                    popover: {
                                        title: 'Goods Receipt',
                                        description: 'The Goods Receipt menu allows you to record received items to ensure stock matches supplier data.'
                                    }
                                },
                                {
                                    element: '.goodReturn',
                                    popover: {
                                        title: 'Goods Return',
                                        description: 'Used to manage the return of items to suppliers due to damage or discrepancies.'
                                    }
                                },
                                // {
                                //     element: '.report',
                                //     popover: {
                                //         title: 'Report',
                                //         description: 'The Report menu provides various reports including sales, returns, members, and vouchers.'
                                //     }
                                // },
                                {
                                    element: '.opname',
                                    popover: {
                                        title: 'Stock Opname',
                                        description: 'Check and match physical stock with the system records.'
                                    }
                                },
                                {
                                    element: '.transferBarang',
                                    popover: {
                                        title: 'Stock Transfer',
                                        description: 'Manage stock transfers between stores or locations.'
                                    }
                                },
                                {
                                    element: '.stok',
                                    popover: {
                                        title: 'Stock',
                                        description: 'Displays an overview of current product stock levels.'
                                    }
                                },
                                {
                                    element: '.kartuStok',
                                    popover: {
                                        title: 'Stock Card',
                                        description: 'Track detailed stock movements for each item.'
                                    }
                                },
                                {
                                    element: '.activityLog',
                                    popover: {
                                        title: 'Activity Log',
                                        description: 'View user activity records in the system for auditing purposes.'
                                    },
                                    onDeselected: () => {
                                        $.ajax({
                                            type: "POST",
                                            url: '/update-status-driver',
                                            data: {
                                                menu: "Home",
                                                _token: '{{ csrf_token() }}'
                                            },
                                            success: function(data) {},
                                            error: function(data, textStatus, errorThrown) {}
                                        });
                                    }
                                }
                            ];

                        });

                        driverObj.drive();
                    }
                @endgudang

                @if ($istutorials)
                    startWebsiteTour();
                @endif
            </script>

            <script>
                function closeTransactionCollapse() {
                    const transactionCollapse = document.getElementById('multiCollapseExample2');
                    const bsCollapse = bootstrap.Collapse.getInstance(transactionCollapse);

                    // Jika collapse terbuka, tutup
                    if (bsCollapse && bsCollapse._isShown) {
                        bsCollapse.hide();
                    }
                }
            </script>

    </html>
