@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="warehouse-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Warehouse') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>
                    <nav class="page-breadcrumb">
                        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Warehouse') }}
                                </li>
                            </ol>
                        </div>
                    </nav>
                    <div class="">

                        <livewire:warehouse.index-warehouse />

                    </div>
                </div>
            </div>
        </div>
    </div>

    @if ($istutorials)
        <script>
            const warehousePopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [
                        {
                            element: '.warehouse-pop',
                            popover: {
                                description: 'In this menu, you can view the list of registered stores.'
                            }
                        },
                        {
                            element: '.add-warehouse-pop',
                            popover: {
                                description: 'Click the button to register a new store.'
                            }
                        },
                        {
                            element: '.go-setting-pop',
                            popover: {
                                description: 'The next step is to register the supplier. Click on the "Settings" menu, then click "Supplier".'
                            },
                            onDeselected: () => {
                                $.ajax({
                                    type: "POST",
                                    url: '/update-status-driver',
                                    data: {
                                        menu: "Warehouse",
                                        _token: '{{ csrf_token() }}'
                                    },
                                    success: function(data) {
                                    },
                                    error: function(data, textStatus, errorThrown) {
                                    },
                                });
                            }
                        },
                    ],
                });

                driverObj.drive();
            }
        </script>
    @endif
@endsection
