@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }

        .toggle-container {
            display: inline-block;
            position: relative;
        }

        .toggle-checkbox {
            display: none;
        }

        .toggle-label {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 50px;
            height: 25px;
            background-color: #cecdcd;
            border-radius: 25px;
            cursor: pointer;
            position: relative;
            transition: background-color 0.3s ease;
        }

        .toggle-checkbox:checked+.toggle-label {
            background-color: #4f52ff;
        }

        .toggle-circle {
            width: 20px;
            height: 20px;
            background-color: white;
            border-radius: 50%;
            position: absolute;
            top: 2.5px;
            left: 3px;
            transition: transform 0.3s ease;
        }

        .toggle-checkbox:checked+.toggle-label .toggle-circle {
            transform: translateX(25px);
        }

        .p-2 div {
            display: flex;
            align-items: center;
            gap: 10px;
        }
    </style>
    <div class="">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Automatic Restocking System (ARS)') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>
                    <nav class="page-breadcrumb">
                        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="/">{{ __('Home') }}</a>
                                </li>
                                <li class="breadcrumb-item active">{{ __('Report') }}</li>
                                <li class="breadcrumb-item active">{{ __('Analysis') }}</li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Automatic Restocking System (ARS)') }}</li>
                            </ol>
                           
                        </div>
                    </nav>

                    <div class="card-body" id="cashier">
                        <livewire:report.analysis.stock-alert />
                    </div>
                </div>
            </div>
        </div>
    </div>

    
@endsection
