<div>
    <form>
        <div class="mb-3">
            <label for="printername" class="form-label">Printer Name</label>
            <input type="text" id="printername" class="form-control" placeholder="Printer Name" wire:model.live="printername">
        </div>
        <div class="mb-3">
            <label for="warehousename" class="form-label">Store Name</label>
            <input type="text" id="warehousename" class="form-control" placeholder="Store Name" wire:model.live="wh_name">
        </div>
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="text" id="email" class="form-control" placeholder="Email" wire:model.live="email">
        </div>
        <div class="mb-3">
            <label for="address" class="form-label">Address</label>
            <input type="text" id="address" class="form-control" placeholder="Address" wire:model.live="address">
        </div>
        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input type="text" id="phone" class="form-control" placeholder="Phone" wire:model.live="phone">
        </div>
        <div class="mb-3">
            <label for="receipt_footer" class="form-label">Receipt Footer</label>
            <textarea id="receipt_footer" class="form-control" placeholder="Footer" wire:model.live="receipt_footer" rows="5"></textarea>
        </div>
        <div class="mb-3">
            <label for="display" class="form-label">Display</label>
            <h4 class="text-center">{!! $footer !!}</h4>
        </div>
        <button type="button" wire:click="save" class="btn btn-primary">Save</button>
    </form>
</div>

<script>
    document.getElementById('receipt_footer').addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
            event.preventDefault();
            const cursorPosition = this.selectionStart;
            const value = this.value;
            const textBefore = value.substring(0, cursorPosition);
            const textAfter = value.substring(cursorPosition);

            this.value = textBefore + "\n" + textAfter;
            this.selectionStart = this.selectionEnd = cursorPosition + 1;
        }
    });
</script>
