@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="member-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Store') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>

                    <nav class="page-breadcrumb">
                        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Select Store') }}
                                </li>
                            </ol>
                        </div>
                    </nav>

                    <div class="" id="cashier">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        @if (session('danger'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('danger') }}
                            </div>
                        @endif

                        <div class="container">
                            <div class="row">
                                @forelse ($warehouse as $item)
                                    <div class="col-md-4">
                                        <div class="card mb-4">
                                            <div class="card-body">
                                                <div class="mb-4">
                                                    {{ $item->code }}
                                                </div>
                                                <h5 class="card-title">{{ $item->name }}</h5>
                                                <div class="d-flex gap-2">
                                                    <div style="width: 30px; height: 30px;">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                            fill="currentColor">
                                                            <path fill-rule="evenodd"
                                                                d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                                                                clip-rule="evenodd" />
                                                        </svg>
                                                    </div>
                                                    <p class="">{{ $item->address }}</p>
                                                </div>
                                            </div>
                                            <div class="card-footer text-muted justify-content-end d-flex">
                                                <a href="#" class="btn btn-primary"
                                                    onclick="selectWarehouse('{{ $item->code }}')">Select</a>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                <div class="d-flex flex-column align-items-center justify-content-center" style="height: 65vh;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor"
                                         class="bi bi-exclamation-triangle-fill text-warning mb-3" viewBox="0 0 16 16">
                                        <path
                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.964 0L.165 13.233c-.457.778.091 1.767.982 1.767h13.706c.89 0 1.438-.989.982-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 4.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1.002 1.002 0 1 0 0 2.002A1.002 1.002 0 0 0 8.002 11z"/>
                                    </svg>
                                    <p class="text-warning text-center mb-3">No store found</p>
                                    <a href="{{ route('warehouse.index') }}" class="btn btn-warning">Create Store</a>
                                </div>
                                @endforelse
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        var previousUrl = "{{ $previousUrl }}";

        function selectWarehouse(code) {
            $.ajax({
                url: '{{ route('update.warehouse') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    whs_code: code
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = previousUrl;
                    }
                }
            });
        }
    </script>
@endsection
