<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renew Access</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://app.midtrans.com/snap/snap.js" data-client-key="{{ config('services.midtrans.clientKey') }}"></script>
</head>

<body class="bg-light">
    <div class="container mt-5">
        <div class="card shadow">
            <div class="card-header text-center">
                <h3>Renew Access</h3>
            </div>
            <div class="card-body text-center">
                <p class="lead">You need to renew your subscription to access this feature.</p>
                <p class="mb-4">Please click the button below to proceed with the payment.</p>
                @admin
                <button id="pay-button" class="btn btn-primary btn-lg">Pay Now!</button>
                @else
                <button class="btn btn-primary btn-lg" disabled>Pay Now!</button>
                @endadmin
            </div>
            <div class="card-footer text-muted text-center">
                &copy; {{ date('Y') }} Softcomp. All rights reserved.
            </div>
        </div>
    </div>

    @admin
    <script type="text/javascript">
        document.getElementById('pay-button').onclick = function () {
            fetch('/get-snap-token', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                },
                body: JSON.stringify({})
            })
            .then(response => response.json())
            .then(data => {
                if (data.snap_token) {
                    snap.pay(data.snap_token, {
                        onSuccess: function(result) {
                            window.location.href = "/";
                        },
                        onPending: function(result) {
                            alert('Payment is pending.');
                        },
                        onError: function(result) {
                            alert('Payment failed.');
                        }
                    });
                } else {
                    alert('Error getting Snap token');
                }
            })
            .catch(error => {
                console.error('Error fetching Snap token:', error);
                alert('An error occurred: ' + error.message);
            });
        };
    </script>
    @endadmin

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
</body>

</html>
