@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="member-page">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Member') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                        {{-- <a href="{{ route('welcome.dashboard') }}" class="btn badge btn-primary">POS</a> --}}
                    </div>

                    <nav class="page-breadcrumb addMemberButton">
                        <div class="d-flex breadcrumb-cashier" style="flex-direction: column">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Member') }}
                                </li>
                            </ol>

                            {{-- <div class="mb-2 sync-data-member">
                                @if ($isloading)
                                    <button type="button" wire:click="sapGetMember" wire:loading.attr="disabled"
                                        wire:target="sapGetMember" class="custom-button1 btn-sm ml-4" disabled>
                                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                                            aria-hidden="true"></span>
                                        <span id="innerSpan">Loading . . .</span>
                                    </button>
                                @else
                                    <button wire:click="firstClickGetMember" wire:loading.attr="disabled"
                                        wire:target="firstClickGetMember" type="button"
                                        class="custom-button1 btn-sm ml-4">{{ __('Sync Data Member') }}</button>
                                    <button wire:click="generateAndSaveQRCode" wire:loading.attr="disabled"
                                        wire:target="generateAndSaveQRCode" class="custom-button1 btn-sm ml-4">Generate Google
                                        QR</button>
                                @endif
                            </div> --}}
                        </div>
                    </nav>

                    <div class="" id="cashier">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        @if (session('danger'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('danger') }}
                            </div>
                        @endif


                        <livewire:pos.member.member-index />

                    </div>
                </div>
            </div>
        </div>
    </div>
    @if ($istutorials)
        <script>
            const memberPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver();
                driverObj.highlight({
                    element: '.add-member-pop',
                    popover: {
                        description: 'Click this button to add new member',
                    },
                    onDeselected: () => {
                        $.ajax({
                            type: "POST",
                            url: '/update-status-driver',
                            data: {
                                menu: "Member",
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                            },
                            error: function(data, textStatus, errorThrown) {
                            },
                        });

                    }
                });
            }
        </script>
    @endif
@endsection
