<div>
    <div class="py-12">
        <div class="table-responsive table-member-tablet member">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: 1rem;">#</th>
                        <th scope="col">{{ __('Code') }}</th>
                        <th scope="col">{{ __('Username') }}</th>
                        <th scope="col">{{ __('Email') }}</th>

                        <th scope="col">{{ __('Store') }}</th>
                        <th scope="col">{{ __('Role') }}</th>
                        <th scope="col" style="border-top-right-radius: 1rem;">{{ __('Status') }}</th>
                    </tr>
                </thead>

                <tbody class="small">
                    @foreach ($users as $key => $user)
                        <tr wire:key="{{ $user->code }}">
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $user->code }}</td>
                            <td style="cursor: pointer;" onclick="handleEditWhsCode('{{ $user->code }}')">{{ $user->username }}</td>
                            <td>{{ $user->email }}</td>
                            @if($user->role != 'Admin')
                            <td>
                                {{ $user->whs_code }}</td>
                            @else
                            <td>
                                {{ $user->whs_code }}</td>
                            @endif
                            <td>{{ $user->role }}</td>

                            <td>
                                {{-- <button class="btn @if ($user->active == 'Y') btn-success @else btn-danger @endif badge" data-bs-toggle="modal" data-bs-target="#modalStatus{{ $user->code }}"> --}}
                                <button
                                    class="btn @if ($user->active == 'Y') btn-success @else btn-danger @endif badge"
                                    data-bs-toggle="modal" data-bs-target="#modalStatus{{ $user->code }}">

                                    @if ($user->active == 'N')
                                        INACTIVE
                                    @else
                                        ACTIVE
                                    @endif
                                </button>
                            </td>
                        </tr>
                        <!-- Modal -->
                    <div class="modal fade" id="modalStatus{{ $user->code }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                            <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Change Member Status</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                            <h3 class="text-center"> Change status for user : {{ $user->username }}</h3>
                            </div>
                            <div class="modal-footer">
                            <button type="button" wire:click="updateStatus('{{ $user->code }}')" class="btn @if ($user->active == 'N') btn-success @else btn-danger @endif" data-bs-dismiss="modal">@if ($user->active == 'Y')
                                INACTIVE
                            @else
                                ACTIVE
                            @endif</button>
                            </div>
                        </div>
                        </div>
                    </div>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="editWhsModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Edit for <span
                            class="text-success">{{ $username }}</span></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" wire:model.live="username" id="username" class="form-control mb-2">
                        @error('username')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="email" id="email" class="form-control mb-2">
                        @error('email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" wire:model.live="password" id="password" class="form-control mb-2">
                        @error('password')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="size_code">Store</label>
                        <select class="form-select mb-2" wire:model="whscode">
                            <option value="">-- Select Store --</option>
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->code }} || {{ $whs->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('whscode')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="size_code">Role</label>
                        <select class="form-select mb-2" wire:model="role">
                            <option value="Cashier">Kasir</option>
                            <option value="Gudang">Gudang</option>
                        </select>

                        @error('whscode')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click="saveEdit">Save</button>
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" id="createNewUser" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Create User</span></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" wire:model.live="username" id="username" class="form-control mb-2">
                        @error('username')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="email" id="email" class="form-control mb-2">
                        @error('email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" wire:model.live="password" id="password" class="form-control mb-2">
                        @error('password')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="size_code">Store</label>
                        <select class="form-select mb-2" wire:model="whscode">
                            <option value="">-- Select Store --</option>
                            @foreach ($warehouse as $whs)
                                <option value="{{ $whs->code }}">{{ $whs->code }} || {{ $whs->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('whscode')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="size_code">Role</label>
                        <select class="form-select mb-2" wire:model="role">
                            <option value="Cashier">Kasir</option>
                            <option value="Gudang">Gudang</option>
                        </select>

                        @error('whscode')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click="createUser">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts
<script>
    function handleEditWhsCode(code) {
        Livewire.dispatch('editWhsCode', {
            code: code,
        });
    }

    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });

    Livewire.on('openTabelEditWhs', () => {
        $('#editWhsModal').modal('show');
    });

    Livewire.on('closeTabelEditWhs', () => {
        $('#editWhsModal').modal('hide');
    });

    Livewire.on('closeTabelCreateUser', () => {
        $('#createNewUser').modal('hide');
    });
</script>
