<div class="search-container">
    <div class="form-group" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
        <input type="text" wire:model.live="searchTerm" class="form-control" placeholder="Scan Product Here"
            @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($results) - 1 }})"
            @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
            x-on:keydown.enter="
            if(selectedIndex == -1){
                $wire.selectProductByName({{ $index }});
            }else{
                $wire.selectProduct({{ $index }}, selectedIndex);
                selectedIndex = -1;
            }">
        @if (!empty($searchTerm) && !empty($filteredProducts) && $selectedProduct === null)
            <div class="dropdown-menu d-block py-0">
                @foreach ($filteredProducts as $idx => $product)
                <div class="px-2 py-1 border-bottom">
                    <div class="d-flex flex-column ml-3"
                        :class="{ 'bg-primary': selectedIndex === {{ $idx }} }">
                        <button class="btn" :class="{ 'text-white': selectedIndex === {{ $idx }} }"
                            wire:click="selectProductByClick('{{ $index }}', '{{ $product->code }}')">
                            {{ $product->barcode }} || {{ $product->name }} ||
                            {{ 'Rp. ' . number_format($product->price, 0, ',', '.') }}
                        </button>
                    </div>
                </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
