<div class="card mt-4">
    <div class="card-header">>
        Total Return: {{ 'Rp ' . number_format($selectedItemsPrice, 0, ',', '.') }} - {{ 'Rp ' . number_format($totalPrice, 0, ',', '.') }} =
        <span class="{{ $selectedItemsPrice < $totalPrice ? 'text-danger' : 'text-success' }} fw-bold">
            {{ 'Rp ' . number_format($selectedItemsPrice - $totalPrice, 0, ',', '.') }}
        </span>
    </div>
    <div class="card-body">
        @foreach ($inputs as $index => $input)
        <div class="row mb-3">
            <div class="col">
                <div class="form-group">
                    <label for="filteredItem">Item Barcode</label>
                    <livewire:returnsale.searchproduct :index="$index" :filtered-products="$filteredProducts" wire:model.live="inputs.{{ $index }}.selectedFilteredItem" key="{{ $index }}" :selected-items-price="$selectedItemsPrice" />
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="itemCode">Item Code:</label>
                    <input type="text" wire:model.live="inputs.{{ $index }}.itemCode" id="itemCode" class="form-control">
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="itemName">Name:</label>
                    <input type="text" wire:model.live="inputs.{{ $index }}.itemName" id="itemName" class="form-control">
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="itemQty">Quantity:</label>
                    <input type="number" wire:model.live="inputs.{{ $index }}.itemQty" id="itemQty" class="form-control"
                    @if (Str::startsWith($inputs[$index]['itemCode'], ['FG', 'BUY', 'VOUCHER']))
                    @else
                        min="1"
                    @endif
                    wire:click="updatePriceDisc({{ $index }})">
                </div>
            </div>
            <div class="col">
                <div class="form-group">
                    <label for="itemPrice">Price:</label>
                    <input type="text" wire:model.live="inputs.{{ $index }}.itemPrice" id="itemPrice" class="form-control">
                </div>
            </div>
            <div class="col mt-4">
                @if ($index > 0) <button class="btn btn-danger" wire:click.prevent="remove({{ $index }})"> Remove </button>
                @endif
            </div>
        </div>
        @endforeach


        <div class="col-2">
            <button class="btn btn-primary mb-3" wire:click.prevent="add">Add</i></button>
        </div>
        @if($selectedItemsPrice < $totalPrice) <div class="col-2">
            <button class="btn btn-danger" data-bs-target="#invoiceReturnModal" data-bs-toggle="modal">Save</button>
    </div>
    @else
    <div class="col-2">
        <button class="btn btn-success" wire:click="store">Save</button>
    </div @endif </div>
    <div wire:ignore.self class="modal fade" id="invoiceReturnModal" tabindex="-1" aria-labelledby="invoiceModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="invoiceModalLabel">Payment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group d-flex justify-content-center align-items-center">
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="cashOption" name="paymentOption" value="cash" wire:model.live="paymentOption">
                            <label class="form-check-label" for="cashOption">Cash</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="qrisOption" name="paymentOption" value="qris" wire:model.live="paymentOption">
                            <label class="form-check-label" for="qrisOption">QRIS</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="cardOption" name="paymentOption" value="card" wire:model.live="paymentOption">
                            <label class="form-check-label" for="cardOption">Card</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="multiOption" name="paymentOption" value="multi" wire:model.live="paymentOption">
                            <label class="form-check-label" for="multiOption">Multi</label>
                        </div>
                        @error('paymentOption')
                        <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <hr>
                    @if($paymentOption !== 'card' && $paymentOption !== 'multi')
                    <div class="form-group mt-2">
                        <label for="totalAmount">Total Amount:</label>
                        <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                    </div>
                    @if($paymentOption === 'cash')
                    <div class="form-group">
                        <label for="payment">Payment:</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp.</span>
                            <input type="text" id="paymentInput" class="form-control" wire:model.live.debounce.500ms="payment" x-mask:dynamic="$money($input, ',')" autofocus>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <label class="fs-3" for="change">Change:</label>
                        <span class="fs-3">Rp. </span><span class="fw-bold text-success fs-3" wire:model="change">{{ number_format($change, 0, ',', '.') }}</span>
                    </div>
                    @endif
                    @endif
                    @if ($paymentOption === 'card')
                    <div class="form-group mt-2">
                        <label for="totalAmount">Total Amount:</label>
                        <span>Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                    </div>
                    <div class="form-group">
                        <label for="namaBank">Bank Name</label>
                        <div class="input-group">
                            <select class="input-group-text" id="type" wire:model.live="type">
                                <option value="Credit">Credit</option>
                                <option value="Debit">Debit</option>
                            </select>
                            <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                <option value="BCA">BCA (Bank Central Asia)</option>
                                <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="namaPemegangKartu">Cardholder Name</label>
                        <input type="text" class="form-control" id="namaPemegangKartu" wire:model.live="namaPemegangKartu">
                    </div>
                    <div class="form-group">
                        <label for="nomorKartu">Card Number</label>
                        <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                        @error('nomorKartu')
                        <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                    @endif
                    @if ($paymentOption === 'multi')
                    <div class="form-group mt-2">
                        <label for="totalAmount">Total Amount:</label>
                        <span>Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                    </div>
                    <div class="form-group mt-2">
                        <label for="cash">Cash : </label>
                        <div class="input-group">
                            <span class="input-group-text">Rp.</span>
                            <input type="text" id="cashInput" class="form-control" wire:model.live.debounce.500ms="cash" x-mask:dynamic="$money($input, ',')">
                        </div>
                        <div class="">
                            <label for="totalAmount">Transfer :</label>
                            <span>Rp. </span><span class="fw-bold">{{ number_format($transfer, 0, ',', '.') }}</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="namaBank">Bank Name</label>
                        <div class="input-group">
                            <select class="input-group-text" id="type" wire:model.live="type">
                                <option value="Credit">Credit</option>
                                <option value="Debit">Debit</option>
                            </select>
                            <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                <option value="BCA">BCA (Bank Central Asia)</option>
                                <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="namaPemegangKartu">Cardholder Name</label>
                        <input type="text" class="form-control" id="namaPemegangKartu" wire:model.live="namaPemegangKartu">
                    </div>
                    <div class="form-group">
                        <label for="nomorKartu">Card Number</label>
                        <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                        @error('nomorKartu')
                        <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>

                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" wire:click="storewithmoney">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function updateChangeUI(changeValue) {
        const changeElement = document.querySelector('.change'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    function updateChangeTransfer(changeValue) {
        const changeElement = document.querySelector('.transfer'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    const paymentInput = document.getElementById('paymentInput');
    const cashInput = document.getElementById('cashInput');
    const totalAmountElement = document.getElementById('totalAmount');

    function extractNumericValue(element) {
        if (element) {
            const numericValue = parseFloat(element.textContent.replace(/[^\d]/g, ''));
            return isNaN(numericValue) ? 0 : numericValue;
        }
        return 0;
    }

    const totalAmount = extractNumericValue(totalAmountElement);

    function calculateChange() {
        let inputValue = parseFloat(paymentInput.value.replace(/\./g, ''));

        if (!isNaN(inputValue)) {
            const change = inputValue - totalAmount;
            updateChangeUI(change);
        }
    }

    paymentInput.addEventListener('input', calculateChange);
    calculateChange();

</script>