<div>
    <!-- Modal -->
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Selected Items</h5>
                </div>
                <div class="modal-body">
                @if (!empty($selectedItems))
                    @foreach ($selectedItems as $index => $item)
                        <div class="row mb-3">
                            <div class="col">
                                <div class="form-group">
                                    <label for="Item">Item </label>
                                    <input type="text" class="form-control" value="{{ $item['name'] }} (Price: {{ $item['price'] }})" disabled>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="qty">Qty :</label>
                                    <input
                                    type="number"
                                    class="form-control"
                                    max="{{ $item['qty'] }}"
                                    wire:model.live="inputs.{{ $index }}.qty"
                                    min="1">
                                @error("inputs.{$index}.qty") <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            </div>
                        </div>
                    @endforeach
                @endif
                </div>
                <div class="modal-footer">
                    <button type="button" wire:click="close" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" wire:click="select" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div>
</div>




