<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('report.reporttransfer') }}">{{ __('Transfer') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="button-top-right">
                    <button type="button" class="btn btn-success btn-sm ml-2">
                        <a wire:click="exportExcel" style="text-decoration:none; color:white;">Export</a></button>
                    <button type="button" class="btn btn-secondary btn-sm ml-2">
                        <a href="{{ route('report.reporttransfer') }}"
                            style="text-decoration:none; color:white;">Close</a></button>
                </div>
                <div class="">
                    <div class="card p-2 mb-3 " style="">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Transfer No. ') }} <span
                                    class="">{{ $no->no }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('From Store : ') }} <span
                                    class="">{{ $no->whs_name ?? '-' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('To Store : ') }} <span
                                    class="">{{ $no->whs_to_name ?? '-' }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Date : ') }} <span
                                    class="">{{ $no->date }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span
                                    class="">{{ $no->remark }}</span></h6>
                        </div>
                    </div>

                    <div class="table-responsive table-it-in-detail">
                        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                    <th scope="col">{{ __('Code') }}</th>
                                    <th scope="col">{{ __('Barcode') }}</th>
                                    <th scope="col">{{ __('Name') }}</th>
                                    @if ($no->status == 5 || $no->status == 4)
                                    <th scope="col">{{ __('Qty Request') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Send') }}
                                    @elseif ($no->status == 1)
                                    <th scope="col">{{ __('Qty Send') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Receive') }}
                                    @elseif($no->status == 2 || $no->status == 3)
                                    <th scope="col">{{ __('Qty Send') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty Receive') }}
                                    @endif
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="small">
                                @foreach ($details as $key => $detail)
                                    <tr>
                                        <th scope="col">{{ $key + 1 }}</td>
                                        <td>{{ $detail->code }}</td>
                                        <td>{{ $detail->barcode }}</td>
                                        <td>{{ $detail->name }}</td>
                                        @if($no->status == 5 || $no->status == 4)
                                        <td>{{ number_format($detail->qty_request) }}</td>
                                        <td>{{ number_format($detail->qty_open) }}</td>
                                        @elseif ($no->status == 1)
                                        <td>{{ number_format($detail->qty_open) }}</td>
                                        <td>{{ number_format($detail->qty_close) }}</td>
                                        @elseif($no->status == 2 || $no->status == 3)
                                        <td>{{ number_format($detail->qty_open) }}</td>
                                        <td>{{ number_format($detail->qty_close) }}</td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div wire:ignore.self>
                        <table id="table" class="table dataTables_wrapper dt-bootstrap5 text-white"
                            style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col" colspan="3"></th>
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty Send') }}</th>
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty Receive') }}</th>
                                </tr>
                            </thead>

                            <tbody class="small">

                                <tr>
                                    <td colspan="2">Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td colspan="3"></td>
                                    <td style="text-align: right;">
                                        {{ number_format($details->sum('qty_open'), 0, ',', ',') }}</td>
                                    <td style="text-align: right;">
                                        {{ number_format($details->sum('qty_close'), 0, ',', ',') }}</td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>
