<div class="">
    <div class="form-group row">
        <div class="col-md-2">
            <label for="startDate">Period</label>
            <input type="date" class="form-control" id="startDate" wire:model="startDate">
        </div>
        <div class="col-md-2">
            <label for="endDate">Period</label>
            <input type="date" class="form-control" id="endDate" wire:model="endDate">
        </div>
        @if ($startDate != '')
            <div class="col-md-4 mt-4">
                <button type="button" wire:click="filters" class="btn btn-primary mb-2">Filter</button>
                <button type="button" wire:click="clearfilters" class="btn btn-danger mb-2">Clear Filter</button>
            </div>
        @else
            <div class="col-md-4 mt-4">
                <button type="button" class="btn btn-primary mb-2" disabled>Filter</button>
                <button type="button" class="btn btn-danger mb-2" disabled>Clear Filter</button>
            </div>
        @endif
    </div>

    <div class="col-sm-4 col-md-4 col-lg-3 mb-3" x-data="{ selectedIndexItem: null }" x-init="selectedIndexItem = -1">
        <div class="form-group">
            <div class="d-flex" style="flex-direction: column">
                <label for="searchItemInput">Item</label>
                <input type="text" class="form-control rounded" wire:model.debounce.100ms.live="searchitem"
                    id="searchItemInput" placeholder="Search Item"
                    @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                    @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                    x-on:keydown.enter="    
    if(selectedIndexItem == -1) {

    }else{
        $wire.selectItem(selectedIndexItem);
        selectedIndexItem = -1;
    }"
                    autocomplete="off">
            </div>
            @if ($selectedItem === null)
                @if ($resultitem)
                    <div class="dropdown-menu d-block py-0">
                        @foreach ($resultitem as $index => $item)
                            <div class="px-2 py-1 border-bottom"
                                :class="{ 'bg-primary': selectedIndexItem === {{ $index }} }">
                                <div class="d-flex flex-column ml-3">
                                    <button type="button" class="btn btn-link"
                                        :class="{ 'text-white': selectedIndexItem === {{ $index }} }"
                                        wire:click="selectItemByClick('{{ $item->code }}')">
                                        {{ $item->code }} || {{ $item->name }}
                                    </button>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            @endif
        </div>
    </div>
    @admin
        <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
            <div class="form-group">
                <div class="d-flex" style="flex-direction: column">
                    <label for="searchItemInput">Store</label>
                    <input type="text" class="form-control rounded" wire:model.debounce.100ms.live="searchwarehouse"
                        id="searchWarehouseInput" placeholder="Search Store"
                        @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                        @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                        x-on:keydown.enter="    
    if(selectedIndexWarehouse == -1) {

    }else{
        $wire.selectWarehouse(selectedIndexWarehouse);
        selectedIndexWarehouse = -1;
    }"
                        autocomplete="off">
                </div>
                @if ($selectedWarehouse === null)
                    @if ($resultwarehouse)
                        <div class="dropdown-menu d-block py-0">
                            @foreach ($resultwarehouse as $index => $item)
                                <div class="px-2 py-1 border-bottom"
                                    :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                    <div class="d-flex flex-column ml-3">
                                        <button type="button" class="btn btn-link"
                                            :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                            wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                            {{ $item->code }} || {{ $item->name }}
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @endif
            </div>
        </div>
    @endadmin
    {{-- <div x-data="{ open: false, allChecked: false, search: '' }" class="col-sm-4 col-md-4 col-lg-3" @click.away="open = false">
        <label for="warehouse" class="form-label">{{ __('Warehouse') }}</label>
        @if ($flagWhs)
            <button class="form-control form-control-sm" x-on:click.prevent="open = !open"
                x-text="(allChecked ? 'All Selected' : '-- Select Warehouse --')">
                -- Select Warehouse --
            </button>
        @else
            <button class="form-control form-control-sm border border-danger" x-on:click.prevent="open = !open"
                x-text="(allChecked ? 'All Selected' : '-- Select Warehouse --')">
                -- Select Warehouse --
            </button>
            <span class="text-danger">Warehouse is required.</span>
        @endif
        <div x-show.important="open" x-transition class="form-control dropdown-menu d-block py-0 w-auto px-2">
            <div class="mt-2 ms-2 mb-2">
                <input type="checkbox" id="whsSelectAll" name="whsSelectAll" x-model="allChecked"
                    wire:model.live="whsSelectAll">
                <label for="selectAllCheckbox" class="ms-2">Select All</label>
            </div>
            <input type="text" x-model="search" class="form-control form-control-sm mb-2"
                placeholder="Search warehouses...">
            @foreach ($whs as $wh)
                <div class="ms-4" x-show="containsIgnoreCase('{{ $wh->name }}', search)">
                    <input x:checked="allChecked && whsCheckboxes.{{ $wh->code }}" x-bind:hidden="allChecked"
                        type="checkbox" id="whsCheckboxes{{ $wh->code }}" name="whsCheckboxes{{ $wh->code }}"
                        wire:model="whsCheckboxes.{{ $wh->code }}"
                        x-on:change.live="updateWhsCheckboxes('{{ $wh->code }}')">
                    <label x-bind:hidden="allChecked" class="ms-2"
                        for="whsCheckboxes{{ $wh->code }}">{{ $wh->name }}</label>
                </div>
            @endforeach
        </div>
    </div> --}}

    <div class="col-md-4
                mt-2">
        <button type="button" wire:click="exportExcel" class="btn btn-primary mb-2">Export Excel</button>
    </div>

    <table id="example" class="my-table mt-2" style="width:100%">
        @php
            $cumulativeTotal = 0;
        @endphp
        <thead>
            <tr>
                <th scope="col" style="border-top-left-radius: 1rem">#</th>
                {{-- <th scope="col">{{ __('Code') }}</th>
                <th scope="col">{{ __('Barcode') }}</th>
                <th scope="col">{{ __('Name') }}</th> --}}
                <th scope="col">{{ __('Date') }}</th>
                <th scope="col">{{ __('Tipe') }}</th>
                <th scope="col">{{ __('No') }}</th>
                <th scope="col">{{ __('Store') }}</th>
                <th scope="col">{{ __('Qty') }}</th>
                <th scope="col" style="border-top-right-radius: 1rem">{{ __('Cumulative') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($stockcard as $key => $item)
                @php
                    $cumulativeTotal += $item->total_qty;
                @endphp
                <tr>
                    <td scope="col">{{ $loop->iteration }}</td>
                    {{-- <td>{{ $item->code }}</td>
                    <td>{{ $item->barcode }}</td>
                    <td>{{ $item->name }}</td> --}}
                    <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                    <td>
                        @if ($item->tipe == 1)
                            Goods Receive
                        @elseif($item->tipe == 2)
                            Goods Return
                        @elseif($item->tipe == 3)
                            Transfer
                        @elseif($item->tipe == 4)
                            Sales
                        @elseif($item->tipe == 5)
                            Adjustment
                        @else
                            Opening Balance
                        @endif
                    </td>
                    <td>{{ $item->no_trans }}</td>
                    <td>{{ $item->whs_name ?? '-' }}</td>
                    <td>{{ number_format($item->total_qty) }}</td>
                    <td>{{ number_format($cumulativeTotal) }}</td>
                </tr>
            @endforeach
        </tbody>

        <footer>
            <tr>
                <th colspan="6"><strong>Total</strong></th>
                <th><strong>{{ number_format($cumulativeTotal) }}</strong></th>
            </tr>
        </footer>
    </table>
</div>

@livewireScripts

<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                "ordering": false
            });
        });
    });
</script>
