<div class="">
    <ul class="nav nav-tabs mb-3">
        <li class="nav-item">
            <a wire:click="focusedHeaderTrue" type="button"
                @if ($focusedHeader) class="nav-link active" aria-current="page" @else class="nav-link" @endif>Resume</a>
        </li>
        <li class="nav-item">
            <a wire:click="focusedHeaderFalse" type="button"
                @if ($focusedHeader) class="nav-link" @else class="nav-link active" aria-current="page" @endif>Detail</a>
        </li>
    </ul>

    <div class="form-group row">
        <div class="col-md-4">
            <label for="startDate">Start Date</label>
            <input type="date" class="form-control" id="startDate" wire:model="startDate">
        </div>
        <div class="col-md-4">
            <label for="endDate">End Date</label>
            <input type="date" class="form-control" id="endDate" wire:model="endDate">
        </div>
        @if ($startDate != '')
            <div class="col-md-4 mt-4">
                <button type="button" wire:click="filters" class="btn btn-primary mb-2">Filter</button>
                <button type="button" wire:click="clearfilters" class="btn btn-danger mb-2">Clear Filter</button>
            </div>
        @else
            <div class="col-md-4 mt-4">
                <button type="button" class="btn btn-primary mb-2" disabled>Filter</button>
                <button type="button" class="btn btn-danger mb-2" disabled>Clear Filter</button>
            </div>
        @endif
    </div>
    <div class="col-sm-4 col-md-4 col-lg-3 mt-2" x-data="{ selectedIndexSupplier: null }" x-init="selectedIndexSupplier = -1">
        <div class="form-group">
            <div class="d-flex" style="flex-direction: column">
                <label for="searchSupplierInput">Supplier</label>
                <input type="text" class="form-control rounded" wire:model.debounce.100ms.live="searchsupplier"
                    id="searchSupplierInput" placeholder="Select Supplier"
                    @keydown.arrow-down.prevent="selectedIndexSupplier = Math.min(selectedIndexSupplier + 1, 10)"
                    @keydown.arrow-up.prevent="selectedIndexSupplier = Math.max(selectedIndexSupplier - 1, -1)"
                    x-on:keydown.enter="
                if(selectedIndexSupplier == -1) {

                }else{
                    $wire.selectSupplier(selectedIndexSupplier);
                    selectedIndexSupplier = -1;
                }"
                    autocomplete="off">
            </div>
            @if ($selectedSupplier === null)
                @if ($results)
                    <div class="dropdown-menu d-block py-0">
                        @foreach ($results as $index => $supplier)
                            <div class="px-2 py-1 border-bottom"
                                :class="{ 'bg-primary': selectedIndexSupplier === {{ $index }} }">
                                <div class="d-flex flex-column ml-3">
                                    <button type="button" class="btn btn-link"
                                        :class="{ 'text-white': selectedIndexSupplier === {{ $index }} }"
                                        wire:click="selectSupplierByClick('{{ $supplier->code }}')">
                                        {{ $supplier->code }} || {{ $supplier->name }} || {{ $supplier->email }}
                                    </button>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            @endif
        </div>
    </div>
    @admin
        <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
            <div class="form-group">
                <div class="d-flex" style="flex-direction: column">
                    <label for="searchItemInput">Store</label>
                    <input type="text" class="form-control rounded" wire:model.debounce.100ms.live="searchwarehouse"
                        id="searchWarehouseInput" placeholder="Search Store"
                        @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                        @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                        x-on:keydown.enter="
    if(selectedIndexWarehouse == -1) {

    }else{
        $wire.selectWarehouse(selectedIndexWarehouse);
        selectedIndexWarehouse = -1;
    }"
                        autocomplete="off">
                </div>
                @if ($selectedWarehouse === null)
                    @if ($resultwarehouse)
                        <div class="dropdown-menu d-block py-0">
                            @foreach ($resultwarehouse as $index => $item)
                                <div class="px-2 py-1 border-bottom"
                                    :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                    <div class="d-flex flex-column ml-3">
                                        <button type="button" class="btn btn-link"
                                            :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                            wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                            {{ $item->code }} || {{ $item->name }}
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @endif
            </div>
        </div>
    @endadmin
    @if ($focusedHeader)
        <div class="col-md-4
                mt-2">
            <button type="button" wire:click="exportExcel" class="btn btn-primary mb-2">Export Excel</button>
        </div>

        <table id="example" class="my-table mt-2" style="width:100%">
            <thead>
                <tr>
                    <th scope="col" style="border-top-left-radius: 1rem">#</th>
                    <th scope="col">{{ __('Action') }}</th>
                    <th scope="col">{{ __('No') }}</th>
                    <th scope="col">{{ __('Store') }}</th>
                    <th scope="col">{{ __('Date') }}</th>
                    <th scope="col">{{ __('Supplier') }}</th>
                    <th scope="col">{{ __('Remark') }}</th>
                    <th scope="col">{{ __('Qty') }}</th>
                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Total') }}
                    </th>

                </tr>
            </thead>
            <tbody>
                @forelse($purchase as $key => $item)
                    <tr>
                        <td scope="col">{{ $loop->iteration }}</td>
                        <td> <button class="btn btn-primary content-end goodsReceipt-detail-pop"
                                style="padding: 2.5px 5px; font-size: 12px;">
                                <a href="/report/goodsreceipt/detail/{{ $item->no }}"
                                    style="text-decoration: none; color:white;">Detail</a></button>

                            {{-- <button type="button" class="btn btn-danger content-end delete-promo"
                            style="padding: 5px 10px; font-size: 12px;" @admin data-bs-toggle="modal"
                            data-bs-target="#deleteModal" onclick="handleremoveItem('{{ $item->no }}')" @else
                            disabled @endadmin>
                            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor"
                                class="bi bi-trash" viewBox="0 0 16 16">
                                <path
                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                <path
                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                            </svg>
                        </button> --}}
                        </td>
                        <td> {{ $item->no }}</td>
                        <td>{{ $item->whs_name ?? '-' }}</td>
                        <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                        <td>{{ $item->name }}</td>
                        <td>{{ $item->remark }}</td>
                        <td>{{ $item->qty }}</td>
                        <td>
                            {{ 'Rp. ' . number_format($item->total, 0, ',', '.') }}
                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>
    @else
        <div class="col-md-4
                mt-2">
            <button type="button" wire:click="exportExcelDetail" class="btn btn-primary mb-2">Export Excel</button>
        </div>
        <table id="exampleDet" class="my-table mt-2" style="width:100%">
            <thead>
                <tr>
                    <th scope="col" style="border-top-left-radius: 1rem">#</th>
                    <th scope="col">{{ __('No') }}</th>
                    <th scope="col">{{ __('Store') }}</th>
                    <th scope="col">{{ __('Date') }}</th>
                    <th scope="col">{{ __('Supplier') }}</th>
                    <th scope="col">{{ __('Code') }}</th>
                    <th scope="col">{{ __('Barcode') }}</th>
                    <th scope="col">{{ __('Name') }}</th>
                    <th scope="col">{{ __('Qty') }}</th>
                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Total') }}
                    </th>

                </tr>
            </thead>
            <tbody>
                @forelse($purchaseDet as $key => $item)
                    <tr>
                        <td scope="col">{{ $loop->iteration }}</td>
                        <td> {{ $item->no }}</td>
                        <td>{{ $item->whs_name ?? '-' }}</td>
                        <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                        <td>{{ $item->supp }}</td>
                        <td>{{ $item->code }}</td>
                        <td>{{ $item->barcode }}</td>
                        <td>{{ $item->name }}</td>
                        <td>{{ $item->qty }}</td>
                        <td>
                            {{ 'Rp. ' . number_format($item->total, 0, ',', '.') }}
                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>
    @endif

    <!-- Modal -->
    {{-- <div wire:ignore.self class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Invoices</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    @if ($data)
                        @foreach ($data as $invoice)
                            <div class="card mt-2">
                                <div wire:click="exportExcelDetail('{{ $invoice->no }}')" class="card-body"
                                    style="cursor: pointer;">
                                    <p>Invoice: {{ $invoice->no }}</p>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div> --}}
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });

            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#exampleDet', {
                order: [],
            });
        });
    });
</script>
