<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-end align-items-center">
                <div class="">
                    <button wire:navigate href="/" type="button"
                        class="btn btn-secondary btn-sm">{{ __('Back') }}</button>
                </div>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">
                                {{ __('Filter Automatic Restocking System (ARS)') }}</h6>
                        </div>

                        <div class="mb-3 form-group row">
                            <div class="col">
                                <label for="period" class="form-label">Stock Period</label>
                                <input wire:model.live="period" type="date"
                                    class="form-control @error('period') is-invalid @enderror form-control-sm"
                                    id="period">
                                @error('period')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col"></div>
                        </div>
                        <div class="mb-3 form-group row">
                            <div class="col">
                                <label for="filterby" class="form-label">{{ __('Filter') }}</label>
                                <select wire:model.live="filterby"
                                    class="form-select @error('filterby') is-invalid @enderror form-select-sm"
                                    id="filterby">
                                    <option value="">-- {{ __('Select filter') }} --</option>
                                    @foreach ($udfs as $udf)
                                        <option value="{{ $udf->field }}|{{ $udf->name }}">
                                            {{ $udf->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('filterby')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col">
                                @if ($filterby != '')
                                    <div x-data="{ 
                                        open: false, 
                                        allChecked: @entangle('searchSelectAll1'),
                                        search: '' 
                                    }" class="col" @click.away="open = false">
                                        <label class="form-label">{{ $searchby }}</label>
                                        @if ($flagFilter1)
                                            <button class="form-control form-control-sm"
                                                x-on:click.prevent="open = !open"
                                                x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                -- Select {{ $searchby }} --
                                            </button>
                                        @else
                                            <button class="form-control form-control-sm border border-danger"
                                                x-on:click.prevent="open = !open"
                                                x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby }} --')">
                                                -- Select {{ $searchby }} --
                                            </button>
                                            <span class="text-danger">{{ $searchby }} is required.</span>
                                        @endif
                                        <div x-show.important="open" x-transition
                                            class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                            <div class="mt-2 ms-2 mb-2">
                                                <input type="checkbox" id="searchSelectAll1" name="searchSelectAll1"
                                                    x-model="allChecked">
                                                <label class="ms-2">Select All</label>
                                            </div>
                                            <input type="text" x-model="search"
                                                class="form-control form-control-sm mb-2"
                                                placeholder="Search {{ $searchby }}...">
                                            @forelse ($search1 ?? [] as $search)
                                                <div class="ms-4"
                                                    x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                    <input type="checkbox"
                                                        id="searchCheckboxes1{{ $search->code }}"
                                                        name="searchCheckboxes1{{ $search->code }}"
                                                        wire:model.live="searchCheckboxes1.{{ $search->code }}"
                                                        x-bind:checked="allChecked"
                                                        x-on:change="if(!$event.target.checked) allChecked = false">
                                                    <label class="ms-2"
                                                        for="searchCheckboxes1{{ $search->code }}">{{ $search->name }}</label>
                                                </div>
                                            @empty
                                                <div class="ms-4">No items found</div>
                                            @endforelse
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        @if ($filterby != '')
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="filterby2" class="form-label">{{ __('Filter II') }}</label>
                                    <select wire:model.live="filterby2"
                                        class="form-select @error('filterby2') is-invalid @enderror form-select-sm"
                                        id="filterby2">
                                        <option value="">-- {{ __('Select filter II') }} --</option>
                                        @foreach ($udf2s as $udf)
                                            <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                {{ $udf->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('filterby2')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($filterby2 != '')
                                        <div x-data="{ 
                                            open: false, 
                                            allChecked: @entangle('searchSelectAll2'),
                                            search: '' 
                                        }" class="col" @click.away="open = false">
                                            <label class="form-label">{{ $searchby2 }}</label>
                                            @if ($flagFilter2)
                                                <button class="form-control form-control-sm"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                    -- Select {{ $searchby2 }} --
                                                </button>
                                            @else
                                                <button class="form-control form-control-sm border border-danger"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby2 }} --')">
                                                    -- Select {{ $searchby2 }} --
                                                </button>
                                                <span class="text-danger">{{ $searchby2 }} is required.</span>
                                            @endif
                                            <div x-show.important="open" x-transition
                                                class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                <div class="mt-2 ms-2 mb-2">
                                                    <input type="checkbox" id="searchSelectAll2" name="searchSelectAll2"
                                                        x-model="allChecked">
                                                    <label class="ms-2">Select All</label>
                                                </div>
                                                <input type="text" x-model="search"
                                                    class="form-control form-control-sm mb-2"
                                                    placeholder="Search {{ $searchby2 }}...">
                                                @forelse ($search2 ?? [] as $search)
                                                    <div class="ms-4"
                                                        x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                        <input type="checkbox"
                                                            id="searchCheckboxes2{{ $search->code }}"
                                                            name="searchCheckboxes2{{ $search->code }}"
                                                            wire:model.live="searchCheckboxes2.{{ $search->code }}"
                                                            x-bind:checked="allChecked"
                                                            x-on:change="if(!$event.target.checked) allChecked = false">
                                                        <label class="ms-2"
                                                            for="searchCheckboxes2{{ $search->code }}">{{ $search->name }}</label>
                                                    </div>
                                                @empty
                                                    <div class="ms-4">No items found</div>
                                                @endforelse
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        @if ($filterby != '' && $filterby2 != '')
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="filterby3" class="form-label">{{ __('Filter III') }}</label>
                                    <select wire:model.live="filterby3"
                                        class="form-select @error('filterby3') is-invalid @enderror form-select-sm"
                                        id="filterby3">
                                        <option value="">-- {{ __('Select filter III') }} --</option>
                                        @foreach ($udf3s as $udf)
                                            <option value="{{ $udf->field }}|{{ $udf->name }}">
                                                {{ $udf->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('filterby3')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($filterby3 != '')
                                        <div x-data="{ 
                                            open: false, 
                                            allChecked: @entangle('searchSelectAll3'),
                                            search: '' 
                                        }" class="col" @click.away="open = false">
                                            <label class="form-label">{{ $searchby3 }}</label>
                                            @if ($flagFilter3)
                                                <button class="form-control form-control-sm"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                    -- Select {{ $searchby3 }} --
                                                </button>
                                            @else
                                                <button class="form-control form-control-sm border border-danger"
                                                    x-on:click.prevent="open = !open"
                                                    x-text="(allChecked ? 'All Selected' : '-- Select {{ $searchby3 }} --')">
                                                    -- Select {{ $searchby3 }} --
                                                </button>
                                                <span class="text-danger">{{ $searchby3 }} is required.</span>
                                            @endif
                                            <div x-show.important="open" x-transition
                                                class="form-control dropdown-menu d-block py-0 w-auto px-3">
                                                <div class="mt-3 ms-3 mb-3">
                                                    <input type="checkbox" id="searchSelectAll3" name="searchSelectAll3"
                                                        x-model="allChecked">
                                                    <label class="ms-3">Select All</label>
                                                </div>
                                                <input type="text" x-model="search"
                                                    class="form-control form-control-sm mb-3"
                                                    placeholder="Search {{ $searchby3 }}...">
                                                @forelse ($search3 ?? [] as $search)
                                                    <div class="ms-4"
                                                        x-show="containsIgnoreCase('{{ $search->name }}', search)">
                                                        <input type="checkbox"
                                                            id="searchCheckboxes3{{ $search->code }}"
                                                            name="searchCheckboxes3{{ $search->code }}"
                                                            wire:model.live="searchCheckboxes3.{{ $search->code }}"
                                                            x-bind:checked="allChecked"
                                                            x-on:change="if(!$event.target.checked) allChecked = false">
                                                        <label class="ms-3"
                                                            for="searchCheckboxes3{{ $search->code }}">{{ $search->name }}</label>
                                                    </div>
                                                @empty
                                                    <div class="ms-4">No items found</div>
                                                @endforelse
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif



                        <div class="mb-3 form-group row">
                            <div class="col">
                                <div class="mb-2">
                                    <input id="ignore_mdq" wire:model.live="ignore_mdq" type="checkbox"
                                        class="form-check-input">
                                    <label for="ignore_mdq" class="form-check-label">Ignore MDQ</label>
                                </div>
                                @if ($ignore_mdq)
                                    <input wire:model.live="ignore_mdq_day" type="number"
                                        class="form-control form-control-sm @error('ignore_mdq_day') is-invalid @enderror">
                                    @error('ignore_mdq_day')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                @endif
                            </div>
                            <div class="col"></div>
                        </div>

                        @if ($issearch)
                            <button type="button" class="btn btn-primary btn-sm mt-3" disabled>
                                <div class="spinner-border spinner-border-sm" role="status"></div>
                                Get Data
                            </button>
                        @else
                            <button type="button" class="btn btn-primary btn-sm mt-3"
                                wire:click.prevent="checkData">Get Data</button>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <livewire:report.analysis.stock-alert-table :tableName='$tableName' />
    </div>
</div>

@livewireScripts

<script>
    function containsIgnoreCase(str, search) {
        return str.toLowerCase().includes(search.toLowerCase());
    }
</script>
