<div class="row mt-3">
    @if ($data)
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                        <h4 class="card-title" style="color: #1266AB">
                            {{ __('Automatic Restocking System (ARS)') }}</h6>
                            <div>
                                <button type="button" class="btn btn-success btn-sm"
                                    wire:click.prevent="exportData">Export</button>


                                <button type="button" class="btn btn-success btn-sm" 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#confirmModal"
                                    @if($transfersCreated) disabled @endif>
                                    <span wire:loading.remove wire:target="createTransferReturn">
                                        Create Transfer & Return
                                    </span>
                                    <span wire:loading wire:target="createTransferReturn">
                                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                        Processing...
                                    </span>
                                </button>

                                <!-- Confirmation Modal -->
                                <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="confirmModalLabel">Confirmation</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                Are you sure you want to create transfer and return documents?
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="button" class="btn btn-primary" 
                                                    wire:click="createTransferReturn"
                                                    wire:loading.attr="disabled"
                                                    data-bs-dismiss="modal">
                                                    Yes, Create Document
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                    
                    <div class="modal" tabindex="-1" 
                        wire:loading.class="show d-block" 
                        wire:target="createTransferReturn">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content" style="background: transparent; border: none; box-shadow: none;">
                                <div class="modal-body text-center">
                                    <div class="card" style="background: rgba(255,255,255,0.9);">
                                        <div class="card-body">
                                            <div class="spinner-grow text-primary mb-3" style="width: 3rem; height: 3rem;" role="status">
                                                <span class="visually-hidden">Loading...</span>
                                            </div>
                                            <h5 class="text-primary mb-3">Processing</h5>
                                            <p class="mb-0">Please wait, creating transfer and return documents...</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    {{-- <!-- Display Return Items -->
                    @if(isset($sortedData['return']))
                        <div class="return-items">
                            <h3>Return Items</h3>
                            @foreach($sortedData['return'] as $group)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <strong>No:</strong> {{ $group['header']['no'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Date:</strong> {{ $group['header']['date'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>From:</strong> {{ $group['header']['whs_code'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>To:</strong> {{ $group['header']['whs_code_to'] }}
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-md-3">
                                                <strong>Total Qty:</strong> {{ number_format($group['header']['qty']) }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Status:</strong> {{ $group['header']['status'] == 5 ? 'Request' : 'Open' }}
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Remark:</strong> {{ $group['header']['remark'] }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Line</th>
                                                    <th>Item Code</th>
                                                    <th>Qty</th>
                                                    <th>Unit</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($group['details'] as $item)
                                                    <tr>
                                                        <td>{{ $item['linenum'] }}</td>
                                                        <td>{{ $item['item_code'] }}</td>
                                                        <td>{{ number_format($item['qty']) }}</td>
                                                        <td>{{ $item['unit'] }}</td>
                                                        <td>{{ $item['qty_request'] > 0 ? 'Request' : 'Open' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Display Transfer Items -->
                    @if(isset($sortedData['transfer']))
                        <div class="transfer-items">
                            <h3>Transfer Items</h3>
                            @foreach($sortedData['transfer'] as $group)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <strong>No:</strong> {{ $group['header']['no'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Date:</strong> {{ $group['header']['date'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>From:</strong> {{ $group['header']['whs_code'] }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>To:</strong> {{ $group['header']['whs_code_to'] }}
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-md-3">
                                                <strong>Total Qty:</strong> {{ number_format($group['header']['qty']) }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Status:</strong> {{ $group['header']['status'] == 5 ? 'Request' : 'Open' }}
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Remark:</strong> {{ $group['header']['remark'] }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Line</th>
                                                    <th>Item Code</th>
                                                    <th>Qty</th>
                                                    <th>Unit</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($group['details'] as $item)
                                                    <tr>
                                                        <td>{{ $item['linenum'] }}</td>
                                                        <td>{{ $item['item_code'] }}</td>
                                                        <td>{{ number_format($item['qty']) }}</td>
                                                        <td>{{ $item['unit'] }}</td>
                                                        <td>{{ $item['qty_open'] > 0 ? 'Open' : 'Request' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif --}}

                    <div wire:ignore.self class="table-responsive">
                        <div class="mb-3 d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <label class="me-2">Show</label>
                                <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                    <option value="10">10</option>
                                    <option value="20">20</option>
                                    <option value="50">50</option>
                                </select>
                                <label class="">entries</label>
                            </div>
                            <div class="d-flex align-items-center">
                                <label class="me-2">Search</label>
                                <input wire:model.live="search" type="text" class="form-control form-control-sm"
                                    placeholder="Search">
                            </div>
                        </div>

                        <table class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    @foreach(['whs_name' => 'Warehouse', 'code' => 'Code', 'name' => 'Name', 'brand' => 'Brand', 'category' => 'Category', 'size' => 'Size'] as $column => $label)
                                    <th scope="col" rowspan="2" class="align-middle">
                                        <div class="d-flex flex-column">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div wire:click.live="doSort('{{ $column }}')" class="cursor-pointer">
                                                    <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="{{ $label }}" columnNameSort="{{ $column }}" />
                                                </div>
                                                <div class="dropdown">
                                                    <button class="btn btn-link btn-sm p-0 text-muted" type="button" data-bs-toggle="dropdown">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
  <path d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2z"/>
</svg>
                                                        @if(!empty($filters[$column]))
                                                            <span class="badge bg-primary rounded-circle" style="font-size: 8px;">{{ count($filters[$column]) }}</span>
                                                        @endif
                                                    </button>
                                                    <div class="dropdown-menu p-2" style="max-height: 300px; overflow-y: auto; min-width: 200px;">
                                                        <div class="mb-2">
                                                            <div class="form-check d-flex justify-content-between align-items-center">
                                                                <div>
                                                                    <input class="form-check-input" type="checkbox" 
                                                                        wire:model.live="selectAll.{{ $column }}"
                                                                        id="selectAll_{{ $column }}">
                                                                    <label class="form-check-label small fw-normal" for="selectAll_{{ $column }}">
                                                                        Select All
                                                                    </label>
                                                                </div>
                                                                
                                                            </div>
                                                            <div class="d-flex justify-content-end">
                                                                <button type="button" class="btn badge btn-primary me-1"
                                                                    wire:click="$refresh"
                                                                    data-bs-dismiss="dropdown">OK</button>
                                                                {{-- <button type="button" class="btn badge btn-secondary"
                                                                    wire:click="clearFilter('{{ $column }}')">Clear</button> --}}
                                                            </div>
                                                            
                                                            <hr class="my-2">
                                                        </div>
                                                        @foreach($filterOptions[$column] ?? [] as $option)
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox" 
                                                                    wire:model="filters.{{ $column }}" 
                                                                    value="{{ $option }}"
                                                                    id="{{ $column }}_{{ $loop->index }}">
                                                                <label class="form-check-label small fw-normal" for="{{ $column }}_{{ $loop->index }}">
                                                                    {{ $option }}
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </th>
                                    @endforeach
                                    
                                    @foreach(['onhand' => 'Stock', 'sales' => 'Sales', 'recommend' => 'Recommend'] as $column => $label)
                                    <th scope="col" rowspan="2" class="align-middle text-center">
                                        <div class="d-flex flex-column">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div wire:click.live="doSort('{{ $column }}')" class="cursor-pointer">
                                                    <x-datatable-icon :sortColumn="$sortColumn" :sortDirection="$sortDirection" columnName="{{ $label }}" columnNameSort="{{ $column }}" />
                                                </div>
                                                <div class="dropdown">
                                                    <button class="btn btn-link btn-sm p-0 text-muted" type="button" data-bs-toggle="dropdown">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
                                                    <path d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2z"/>
                                                    </svg>
                                                        @if(!is_null($filters_min[$column]) || !is_null($filters_max[$column]))
                                                            <span class="badge bg-primary rounded-circle" style="font-size: 8px;">•</span>
                                                        @endif
                                                    </button>
                                                    <div class="dropdown-menu p-2" style="min-width: 200px;">
                                                        <div class="mb-2">
                                                            <label class="form-label small">Minimum value</label>
                                                            <input type="number" class="form-control form-control-sm" placeholder="Min value" 
                                                                wire:model="filters_min.{{ $column }}">
                                                        </div>
                                                        <div class="mb-2">
                                                            <label class="form-label small">Maximum value</label>
                                                            <input type="number" class="form-control form-control-sm" placeholder="Max value" 
                                                                wire:model="filters_max.{{ $column }}">
                                                        </div>
                                                        <div class="d-flex justify-content-between">
                                                            <button type="button" class="btn btn-sm btn-secondary" 
                                                                wire:click="clearFilter('{{ $column }}')">Clear</button>
                                                            <button type="button" class="btn btn-sm btn-primary" 
                                                                wire:click="$refresh"
                                                                data-bs-dismiss="dropdown">OK</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </th>
                                    @endforeach

                                    <th scope="col">
                                        <div class="d-flex flex-column">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span>Info</span>
                                                <div class="dropdown">
                                                    <button class="btn btn-link btn-sm p-0 text-muted" type="button" data-bs-toggle="dropdown">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
                                                        <path d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2z"/>
                                                        </svg>
                                                        @if(!empty($filters['info']))
                                                            <span class="badge bg-primary rounded-circle" style="font-size: 8px;">{{ count($filters['info']) }}</span>
                                                        @endif
                                                    </button>
                                                    <div class="dropdown-menu p-2">
                                                        <div class="mb-2">
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox" 
                                                                    wire:model.live="selectAll.info"
                                                                    id="selectAll_info">
                                                                <label class="form-check-label small fw-normal" for="selectAll_info">
                                                                    Select All
                                                                </label>
                                                            </div>
                                                            <hr class="my-2">
                                                        </div>
                                                        @foreach(['Transfer', 'Return'] as $option)
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox" 
                                                                    wire:model="filters.info" 
                                                                    value="{{ $option }}"
                                                                    id="info_{{ $loop->index }}">
                                                                <label class="form-check-label small fw-normal" for="info_{{ $loop->index }}">
                                                                    {{ $option }}
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                        <hr class="my-2">
                                                        <div class="d-flex justify-content-between">
                                                            <button type="button" class="btn btn-sm btn-secondary" 
                                                                wire:click="clearFilter('info')">Clear</button>
                                                            <button type="button" class="btn btn-sm btn-primary" 
                                                                wire:click="$refresh"
                                                                data-bs-dismiss="dropdown">OK</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($data as $item)
                                    <tr>
                                        <td scope="col">{{ Str::limit(strip_tags($item->whs_name), 50) }}</td>
                                        <td scope="col">{{ $item->code }}</td>
                                        {{-- <td scope="col">{{ $item->barcode }}</td> --}}
                                        <td scope="col">{{ Str::limit(strip_tags($item->name), 50) }}</td>
                                        <td scope="col">{{ $item->brand }}</td>
                                        <td scope="col">{{ $item->category }}</td>
                                        <td scope="col">{{ $item->size }}</td>
                                        <td scope="col" class="text-center">
                                            {{ number_format($item->onhand) }}
                                        </td>
                                        <td scope="col" class="text-center">
                                            {{ number_format($item->sales) }}
                                        </td>
                                        <td scope="col" class="text-center">
                                            {{ number_format(abs($item->recommend)) }}
                                        </td>
                                        <td scope="col">
                                            @if ($item->recommend > 0)
                                                Transfer
                                            @elseif ($item->recommend < 0)
                                                Return
                                            @else
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        @if ($data)
                            <div class="py-4 px-3">
                                {{ $data->links('vendor.livewire.bootstrap') }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
