<div>
    <div class="col-md-4 mb-4 mt-1 filter-promo-pop">
        <div class="mb-3 form-group row">
            <div class="col">
                <label class="form-label">{{ __('Promo Status') }}</label>
                <select wire:model.live="status" class="form-select form-select-sm" style="border-radius: .5rem">
                    <option value="">{{ __('All') }}</option>
                    <option value="Y">{{ __('Active') }}</option>
                    <option value="N">{{ __('Inactive') }}</option>
                </select>
            </div>
            <div class="col"></div>
        </div>
    </div>

    <div class="card p-4 table-responsive bg-transparent">
        <div class="fs-4 fw-semibold mb-3">Promo List</div>
        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%">
            <thead>
                <tr>
                    <th scope="col" style="border-top-left-radius: .5rem;">#</th>
                    <th scope="col">{{ __('No') }}</th>
                    <th scope="col">{{ __('Name') }}</th>
                    <th scope="col">{{ __('From') }}</th>
                    <th scope="col">{{ __('To') }}</th>
                    <th scope="col">{{ __('Tipe') }}</th>
                    <th scope="col">{{ __('Pricelist') }}</th>
                    <th scope="col">{{ __('Status') }}</th>
                    <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th>
                </tr>
            </thead>

            <tbody>
                @foreach($promos as $promo)
                <tr>
                    <th scope="col">{{ $loop->iteration }}</td>
                    <td>{{ $promo->no }}</td>
                    <td>{{ $promo->name }}</td>
                    <td>{{ $promo->from_date }}</td>
                    <td>{{ $promo->to_date }}</td>
                    <td>
                        @if ($promo->tipe == 1) Discount
                        @elseif ($promo->tipe == 2) Special Price
                        @elseif ($promo->tipe == 3) Bundling
                        @elseif ($promo->tipe == 4) GWP by Qty
                        @elseif ($promo->tipe == 5) GWP by Value
                        @elseif ($promo->tipe == 6) Voucher
                        @elseif ($promo->tipe == 7) Unlimited Bundling
                        @endif
                    </td>
                    <td>{{ $promo->pricelist }}</td>
                    @if ($promo->status == 'Active')
                    <td><span class="badge" style="background-color: #50c87825 ;color: #3fca6d;">{{ $promo->status }}</span></td>
                    @else
                    <td><span class="badge" style="background-color: #eb586e31 ;color: #e93a54;">{{ $promo->status }}</span></td>
                    @endif
                    <td>
                        <button onclick="handlePromoEdit('{{ $promo->no }}');" type="button" class="btn content-end edit-promo-pop" style="background: #00000015; padding: 5px 10px; font-size: 12px;" @admin @else disabled @endadmin>
                            <div style="width: 17px"> 
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                  </svg>
                            </div>
                        </button>

                        <button type="button" class="btn content-end delete-promo" style="background: #00000015; padding: 5px 10px; font-size: 12px;" @admin data-bs-toggle="modal" data-bs-target="#deleteModal{{ $promo->no }}" data-promo-id="{{ $promo->no }}"  @else disabled @endadmin>
                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                            </svg>
                        </button>
                    </td>
                </tr>
                @admin
                <!-- modal delete -->
                <div class="modal fade" id="deleteModal{{ $promo->no }}" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteModalLabel">{{ __('Confirmation') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                            </div>
                            <div class="modal-body">
                                {{ __('Are you sure you want to delete this promo?') }}
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button wire:click="delete({{ $promo->no }})" type="submit" class="btn btn-danger" id="confirm-delete">{{ __('Delete') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
                @endadmin
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@livewireScripts

<script>
    function handlePromoEdit(promoNo) {
        Livewire.dispatch('editPromo', {
            promoNo: promoNo
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        Livewire.on('refreshTable', () => {
            $(document).ready(function() {
                if ($.fn.dataTable.isDataTable('#table')) {
                    $('#table').DataTable().destroy();
                }

                $('#table').DataTable({
                    "lengthMenu": [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ]
                });
            });
        });
    });
</script>