<div class="table-responsive">
    <table class="table">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Code</th>
                <th scope="col">Barcode</th>
                <th scope="col">Name</th>
                <th scope="col">Disc Type</th>
                <th scope="col">Value</th>
            </tr>
        </thead>
        <tbody>
            @foreach($items as $key => $item)
            <tr>
                <td scope="col">{{ $key + 1 }}</td>
                <td>{{ $item->item_code }}</td>
                <td>{{ $item->item_barcode }}</td>
                <td>{{ $item->item_name }}</td>
                @if ($item->disc == 0)
                <td> {{ __('Special Price') }}</td>
                <td>{{ number_format($item->disc_price,0) }}</td>
                @else
                <td> {{ __('Discount (%)') }}</td>
                <td>{{ number_format($item->disc,2) }}</td>
                @endif
                <td>
                    <a wire:click="delete('{{ $item->item_code }}')" style="padding: 5px 10px; font-size: 12px;" class="btn btn-danger btn-sm">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                        </svg>
                    </a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>